/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.UpdateProjectionOptions;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.util.concurrent.CompletableFuture;

class UpdateProjection {
    private final GrpcClient client;
    private final String projectionName;
    private final String query;
    private final Boolean emitEnabled;
    private final UpdateProjectionOptions options;

    public UpdateProjection(GrpcClient client, String projectionName, String query, UpdateProjectionOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.query = query;
        this.emitEnabled = options.isEmitEnabled();
        this.options = options;
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.UpdateReq.Options.Builder optionsBuilder = Projectionmanagement.UpdateReq.Options.newBuilder().setName(this.projectionName).setQuery(this.query);
            if (this.emitEnabled == null) {
                optionsBuilder.setNoEmitOptions(Shared.Empty.newBuilder());
            } else {
                optionsBuilder.setEmitEnabled(this.emitEnabled);
            }
            Projectionmanagement.UpdateReq request = Projectionmanagement.UpdateReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            client.update(request, (StreamObserver<Projectionmanagement.UpdateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }
}

