/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.ManagedChannel;
import io.kurrent.dbclient.CreateChannel;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.Msg;
import io.kurrent.dbclient.OptionsBase;
import io.kurrent.dbclient.ServerInfo;
import io.kurrent.dbclient.ServerVersion;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

class WorkItemArgs {
    private final UUID id;
    private final ManagedChannel channel;
    private final InetSocketAddress endpoint;
    private final ServerInfo info;
    private final LinkedBlockingQueue<Msg> queue;

    public WorkItemArgs(UUID id, ManagedChannel channel, InetSocketAddress endpoint, ServerInfo info, LinkedBlockingQueue<Msg> queue) {
        this.id = id;
        this.channel = channel;
        this.endpoint = endpoint;
        this.info = info;
        this.queue = queue;
    }

    public UUID getId() {
        return this.id;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public Optional<ServerVersion> getServerVersion() {
        return Optional.ofNullable(this.info).map(ServerInfo::getServerVersion);
    }

    public boolean supportFeature(int feature) {
        return this.info != null && this.info.supportFeature(feature);
    }

    public <A> HttpURLConnection getHttpConnection(OptionsBase<A> options, KurrentDBClientSettings settings, String path) {
        try {
            HttpURLConnection conn = (HttpURLConnection)WorkItemArgs.getURL(settings.isTls(), this.endpoint, path).openConnection();
            conn.setRequestProperty("Accept", "application/json");
            String creds = options.getHttpCredentialString();
            if (creds == null && settings.getDefaultCredentials() != null) {
                creds = settings.getDefaultCredentials().basicAuthHeader();
            }
            if (creds != null) {
                conn.setRequestProperty("Authorization", creds);
            }
            return conn;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reportNewLeader(String host, int port) {
        this.queue.add(new CreateChannel(this.id, new InetSocketAddress(host, port)));
    }

    static URL getURL(boolean secure, InetSocketAddress endpoint, String path) {
        String protocol = secure ? "https" : "http";
        try {
            return new URL(protocol + "://" + endpoint.getHostName() + ":" + endpoint.getPort() + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

