/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.ManagedChannel;
import io.kurrent.dbclient.ClientTelemetryAttributes;
import io.kurrent.dbclient.Endpoint;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.UserCredentials;
import java.util.HashMap;

class ClientTelemetryTags
extends HashMap<String, String> {
    ClientTelemetryTags() {
    }

    ClientTelemetryTags(ClientTelemetryTags tags) {
        super(tags);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        final ClientTelemetryTags tags = new ClientTelemetryTags();

        Builder() {
        }

        Builder withServerTagsFromGrpcChannel(ManagedChannel channel) {
            if (channel == null) {
                return this;
            }
            String[] authorityParts = channel.authority().split(":");
            return this.withServerTags(authorityParts[0], authorityParts[1]);
        }

        Builder withServerTagsFromClientSettings(KurrentDBClientSettings settings) {
            if (settings == null || !settings.isDnsDiscover()) {
                return this;
            }
            Endpoint dns = settings.getHosts()[0];
            return this.withServerTags(dns.getHost(), String.valueOf(dns.getPort()));
        }

        private Builder withServerTags(String address, String port) {
            return this.withRequiredTag(ClientTelemetryAttributes.Server.ADDRESS, address).withRequiredTag(ClientTelemetryAttributes.Server.PORT, String.valueOf(port));
        }

        Builder withOptionalDatabaseUserTag(UserCredentials userCredentials) {
            if (userCredentials == null) {
                return this;
            }
            return this.withOptionalTag(ClientTelemetryAttributes.Database.USER, userCredentials.getUsername());
        }

        Builder withRequiredTag(String key, String value) {
            if (key == null) {
                throw new NullPointerException("Required tag key is null.");
            }
            if (value == null) {
                throw new NullPointerException("Required tag value is null.");
            }
            return this.withOptionalTag(key, value);
        }

        Builder withOptionalTag(String key, String value) {
            if (value == null) {
                return this;
            }
            this.tags.put(key, value);
            return this;
        }

        ClientTelemetryTags build() {
            return this.tags;
        }
    }
}

