/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.google.protobuf.ByteString;
import io.kurrent.dbclient.AbstractCreatePersistentSubscription;
import io.kurrent.dbclient.CreatePersistentSubscriptionToStreamOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.PersistentSubscriptionToStreamSettings;
import io.kurrent.dbclient.StreamPosition;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.shared.Shared;

class CreatePersistentSubscriptionToStream
extends AbstractCreatePersistentSubscription<Long, PersistentSubscriptionToStreamSettings> {
    private final String stream;
    private final PersistentSubscriptionToStreamSettings settings;

    public CreatePersistentSubscriptionToStream(GrpcClient client, String stream, String group, CreatePersistentSubscriptionToStreamOptions options) {
        super(client, group, options.getSettings(), options);
        this.stream = stream;
        this.settings = (PersistentSubscriptionToStreamSettings)options.getSettings();
    }

    @Override
    protected Persistent.CreateReq.Settings.Builder createSettings() {
        return Persistent.CreateReq.Settings.newBuilder();
    }

    @Override
    protected Persistent.CreateReq.Options.Builder createOptions() {
        Persistent.CreateReq.Options.Builder optionsBuilder = Persistent.CreateReq.Options.newBuilder();
        Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
        Persistent.CreateReq.StreamOptions.Builder streamOptionsBuilder = Persistent.CreateReq.StreamOptions.newBuilder();
        StreamPosition<Long> position = this.settings.getStartFrom();
        if (position instanceof StreamPosition.Start) {
            streamOptionsBuilder.setStart(Shared.Empty.newBuilder());
        } else if (position instanceof StreamPosition.End) {
            streamOptionsBuilder.setEnd(Shared.Empty.newBuilder());
        } else {
            streamOptionsBuilder.setRevision(position.getPositionOrThrow());
        }
        streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
        streamOptionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        optionsBuilder.setStream(streamOptionsBuilder);
        optionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        return optionsBuilder;
    }
}

