/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GetPersistentSubscriptionInfoOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.HttpUtils;
import io.kurrent.dbclient.PersistentSubscriptionInfo;
import io.kurrent.dbclient.UnsupportedFeatureException;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

final class GetPersistentSubscriptionInfo {
    GetPersistentSubscriptionInfo() {
    }

    public static CompletableFuture<Optional<PersistentSubscriptionInfo>> execute(GrpcClient client, GetPersistentSubscriptionInfoOptions options, String stream, String groupName) {
        return client.runWithArgs(args -> {
            CompletableFuture result = new CompletableFuture();
            if (stream.equals("$all") && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
                return result;
            }
            if (args.supportFeature(30)) {
                Persistent.GetInfoReq.Options.Builder optionsBuilder = Persistent.GetInfoReq.Options.newBuilder();
                if (stream.equals("$all")) {
                    optionsBuilder.setAll(Shared.Empty.getDefaultInstance());
                } else {
                    optionsBuilder.setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)stream)));
                }
                optionsBuilder.setGroupName(groupName);
                Persistent.GetInfoReq req = Persistent.GetInfoReq.newBuilder().setOptions(optionsBuilder).build();
                PersistentSubscriptionsGrpc.PersistentSubscriptionsStub stub = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), client.getSettings(), options);
                CompletableFuture tmp = new CompletableFuture();
                stub.getInfo(req, (StreamObserver<Persistent.GetInfoResp>)GrpcUtils.convertSingleResponse(tmp, resp -> Optional.of(HttpUtils.parseInfoFromWire(resp.getSubscriptionInfo()))));
                tmp.whenCompleteAsync((opt, error) -> {
                    StatusRuntimeException status;
                    if (error instanceof StatusRuntimeException && (status = (StatusRuntimeException)error).getStatus().getCode() == Status.Code.NOT_FOUND) {
                        result.complete(Optional.empty());
                        return;
                    }
                    if (error != null) {
                        result.completeExceptionally((Throwable)error);
                        return;
                    }
                    result.complete(opt);
                });
            } else {
                HttpURLConnection http = args.getHttpConnection(options, client.getSettings(), String.format("/subscriptions/%s/%s/info", HttpUtils.urlEncode(stream), HttpUtils.urlEncode(groupName)));
                try {
                    http.setRequestMethod("GET");
                    int code = http.getResponseCode();
                    if (code == 404) {
                        result.complete(Optional.empty());
                    } else {
                        Exception error2 = HttpUtils.checkForError(http.getResponseCode());
                        if (error2 != null) {
                            result.completeExceptionally(error2);
                        } else {
                            String content = HttpUtils.readContent(http);
                            JsonNode node = HttpUtils.getObjectMapper().readTree(content);
                            result.complete(Optional.of(HttpUtils.parseSubscriptionInfo(node)));
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    http.disconnect();
                }
            }
            return result;
        });
    }
}

