/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GetProjectionResultOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.ThrowingBiFunction;
import io.kurrent.dbclient.ThrowingFunction;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class GetProjectionResult<TResult> {
    private final GrpcClient client;
    private final String projectionName;
    private final GetProjectionResultOptions options;
    private ThrowingBiFunction<JsonMapper, String, TResult, JsonProcessingException> deserializationStrategy;

    GetProjectionResult(GrpcClient client, String projectionName, GetProjectionResultOptions options, Class<TResult> resultType) {
        this(client, projectionName, options, (JsonMapper jsonMapper, String json) -> jsonMapper.readValue(json, resultType));
    }

    GetProjectionResult(GrpcClient client, String projectionName, GetProjectionResultOptions options, Function<TypeFactory, JavaType> javaTypeFunction) {
        this(client, projectionName, options, (JsonMapper jsonMapper, String json) -> jsonMapper.readValue(json, (JavaType)javaTypeFunction.apply(jsonMapper.getTypeFactory())));
    }

    public GetProjectionResult(GrpcClient client, String projectionName, GetProjectionResultOptions options, ThrowingBiFunction<JsonMapper, String, TResult, JsonProcessingException> deserializationStrategy) {
        this.client = client;
        this.projectionName = projectionName;
        this.options = options;
        this.deserializationStrategy = deserializationStrategy;
    }

    public CompletableFuture<TResult> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.ResultReq.Options.Builder optionsBuilder = Projectionmanagement.ResultReq.Options.newBuilder().setName(this.projectionName);
            if (!this.options.getPartition().isEmpty()) {
                optionsBuilder.setPartition(this.options.getPartition());
            }
            Projectionmanagement.ResultReq request = Projectionmanagement.ResultReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            ThrowingFunction converter = source -> {
                String json = JsonFormat.printer().print((MessageOrBuilder)source.getResult());
                return this.deserializationStrategy.apply(new JsonMapper(), json);
            };
            client.result(request, (StreamObserver<Projectionmanagement.ResultResp>)GrpcUtils.convertSingleResponse(result, converter));
            return result;
        });
    }
}

