/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.kurrent.dbclient.AppendToStream;
import io.kurrent.dbclient.AppendToStreamOptions;
import io.kurrent.dbclient.DeleteResult;
import io.kurrent.dbclient.DeleteStream;
import io.kurrent.dbclient.DeleteStreamOptions;
import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.EventDataBuilder;
import io.kurrent.dbclient.KurrentDBClientBase;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.Position;
import io.kurrent.dbclient.ReadAll;
import io.kurrent.dbclient.ReadAllOptions;
import io.kurrent.dbclient.ReadMessage;
import io.kurrent.dbclient.ReadResult;
import io.kurrent.dbclient.ReadStream;
import io.kurrent.dbclient.ReadStreamOptions;
import io.kurrent.dbclient.ReadSubscriber;
import io.kurrent.dbclient.RecordedEvent;
import io.kurrent.dbclient.StreamMetadata;
import io.kurrent.dbclient.StreamNotFoundException;
import io.kurrent.dbclient.SubscribeToAll;
import io.kurrent.dbclient.SubscribeToAllOptions;
import io.kurrent.dbclient.SubscribeToStream;
import io.kurrent.dbclient.SubscribeToStreamOptions;
import io.kurrent.dbclient.Subscription;
import io.kurrent.dbclient.SubscriptionListener;
import io.kurrent.dbclient.WriteResult;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class KurrentDBClient
extends KurrentDBClientBase {
    private KurrentDBClient(KurrentDBClientSettings settings) {
        super(settings);
    }

    public static KurrentDBClient create(KurrentDBClientSettings settings) {
        return new KurrentDBClient(settings);
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, EventData ... events) {
        return this.appendToStream(streamName, Arrays.stream(events).iterator());
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, Iterator<EventData> events) {
        return this.appendToStream(streamName, AppendToStreamOptions.get(), events);
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, AppendToStreamOptions options, EventData ... events) {
        return this.appendToStream(streamName, options, Arrays.stream(events).iterator());
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, AppendToStreamOptions options, Iterator<EventData> events) {
        if (options == null) {
            options = AppendToStreamOptions.get();
        }
        return new AppendToStream(this.getGrpcClient(), streamName, events, options).execute();
    }

    public CompletableFuture<WriteResult> setStreamMetadata(String streamName, StreamMetadata metadata) {
        return this.setStreamMetadata(streamName, null, metadata);
    }

    public CompletableFuture<WriteResult> setStreamMetadata(String streamName, AppendToStreamOptions options, StreamMetadata metadata) {
        JsonMapper mapper = new JsonMapper();
        try {
            EventData event = EventDataBuilder.json("$metadata", mapper.writeValueAsBytes((Object)metadata)).build();
            return this.appendToStream("$$" + streamName, options, event);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<ReadResult> readStream(String streamName, ReadStreamOptions options) {
        return KurrentDBClient.readEventsFromPublisher(this.readStreamReactive(streamName, options));
    }

    public Publisher<ReadMessage> readStreamReactive(String streamName) {
        return this.readStreamReactive(streamName, ReadStreamOptions.get());
    }

    public Publisher<ReadMessage> readStreamReactive(String streamName, ReadStreamOptions options) {
        if (options == null) {
            options = ReadStreamOptions.get();
        }
        return new ReadStream(this.getGrpcClient(), streamName, options);
    }

    public CompletableFuture<StreamMetadata> getStreamMetadata(String streamName) {
        return this.getStreamMetadata(streamName, null);
    }

    public CompletableFuture<StreamMetadata> getStreamMetadata(String streamName, ReadStreamOptions options) {
        return ((CompletableFuture)this.readStream("$$" + streamName, options).thenCompose(result -> {
            RecordedEvent event = result.getEvents().get(0).getOriginalEvent();
            CompletableFuture<StreamMetadata> out = new CompletableFuture<StreamMetadata>();
            try {
                JsonMapper mapper = new JsonMapper();
                StreamMetadata metadata = (StreamMetadata)mapper.readValue(event.getEventData(), StreamMetadata.class);
                out.complete(metadata);
            }
            catch (Throwable e) {
                out.completeExceptionally(e);
            }
            return out;
        })).exceptionally(e -> {
            if (e.getCause() instanceof StreamNotFoundException) {
                return new StreamMetadata();
            }
            throw new RuntimeException((Throwable)e);
        });
    }

    public CompletableFuture<ReadResult> readAll() {
        return this.readAll(ReadAllOptions.get());
    }

    public CompletableFuture<ReadResult> readAll(ReadAllOptions options) {
        return KurrentDBClient.readEventsFromPublisher(this.readAllReactive(options));
    }

    public Publisher<ReadMessage> readAllReactive() {
        return this.readAllReactive(ReadAllOptions.get());
    }

    public Publisher<ReadMessage> readAllReactive(ReadAllOptions options) {
        if (options == null) {
            options = ReadAllOptions.get();
        }
        return new ReadAll(this.getGrpcClient(), options);
    }

    public CompletableFuture<Subscription> subscribeToStream(String streamName, SubscriptionListener listener) {
        return this.subscribeToStream(streamName, listener, SubscribeToStreamOptions.get());
    }

    public CompletableFuture<Subscription> subscribeToStream(String streamName, SubscriptionListener listener, SubscribeToStreamOptions options) {
        if (options == null) {
            options = SubscribeToStreamOptions.get();
        }
        return new SubscribeToStream(this.getGrpcClient(), streamName, listener, options).execute();
    }

    public CompletableFuture<Subscription> subscribeToAll(SubscriptionListener listener) {
        return this.subscribeToAll(listener, SubscribeToAllOptions.get());
    }

    public CompletableFuture<Subscription> subscribeToAll(SubscriptionListener listener, SubscribeToAllOptions options) {
        if (options == null) {
            options = SubscribeToAllOptions.get();
        }
        return new SubscribeToAll(this.getGrpcClient(), listener, options).execute();
    }

    public CompletableFuture<DeleteResult> deleteStream(String streamName) {
        return this.deleteStream(streamName, DeleteStreamOptions.get());
    }

    public CompletableFuture<DeleteResult> deleteStream(String streamName, DeleteStreamOptions options) {
        if (options == null) {
            options = DeleteStreamOptions.get();
        }
        return new DeleteStream(this.getGrpcClient(), streamName, true, options).execute();
    }

    public CompletableFuture<DeleteResult> tombstoneStream(String streamName) {
        return this.tombstoneStream(streamName, DeleteStreamOptions.get());
    }

    public CompletableFuture<DeleteResult> tombstoneStream(String streamName, DeleteStreamOptions options) {
        if (options == null) {
            options = DeleteStreamOptions.get();
        }
        return new DeleteStream(this.getGrpcClient(), streamName, false, options).execute();
    }

    private static CompletableFuture<ReadResult> readEventsFromPublisher(Publisher<ReadMessage> eventPublisher) {
        final CompletableFuture<ReadResult> future = new CompletableFuture<ReadResult>();
        final LinkedList events = new LinkedList();
        eventPublisher.subscribe((Subscriber)new ReadSubscriber(){
            long firstStreamPosition = 0L;
            long lastStreamPosition = 0L;
            Position lastAllStreamPosition = null;

            @Override
            public void onEvent(ReadMessage e) {
                if (e.hasFirstStreamPosition()) {
                    this.firstStreamPosition = e.getFirstStreamPosition();
                    return;
                }
                if (e.hasLastStreamPosition()) {
                    this.lastStreamPosition = e.getLastStreamPosition();
                    return;
                }
                if (e.hasLastAllPosition()) {
                    this.lastAllStreamPosition = e.getLastAllPosition();
                    return;
                }
                if (e.hasEvent()) {
                    events.add(e.getEvent());
                }
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onComplete() {
                future.complete(new ReadResult(events, this.firstStreamPosition, this.lastStreamPosition, this.lastAllStreamPosition));
            }
        });
        return future;
    }
}

