/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.ListProjectionsOptions;
import io.kurrent.dbclient.ListProjectionsResult;
import io.kurrent.dbclient.ProjectionDetails;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

class ListProjections {
    private final GrpcClient client;
    private final ListProjectionsOptions options;

    public ListProjections(GrpcClient client, ListProjectionsOptions options) {
        this.client = client;
        this.options = options;
    }

    public CompletableFuture<ListProjectionsResult> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.StatisticsReq.Options.Builder optionsBuilder = Projectionmanagement.StatisticsReq.Options.newBuilder().setContinuous(Shared.Empty.newBuilder());
            Projectionmanagement.StatisticsReq request = Projectionmanagement.StatisticsReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            final CompletableFuture future = new CompletableFuture();
            final ArrayList projections = new ArrayList();
            client.statistics(request, new StreamObserver<Projectionmanagement.StatisticsResp>(){

                public void onNext(Projectionmanagement.StatisticsResp value) {
                    if (value.hasDetails()) {
                        projections.add(ProjectionDetails.fromWire(value.getDetails()));
                    }
                }

                public void onCompleted() {
                    future.complete(new ListProjectionsResult(projections));
                }

                public void onError(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        });
    }
}

