/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.Position;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.shared.Shared;
import io.kurrent.dbclient.proto.streams.StreamsOuterClass;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.constraints.NotNull;

public class RecordedEvent {
    @NotNull
    private final String streamId;
    @NotNull
    private final long revision;
    @NotNull
    private final UUID eventId;
    @NotNull
    private final String eventType;
    @NotNull
    private final byte[] eventData;
    @NotNull
    private final byte[] userMetadata;
    @NotNull
    private final Instant created;
    @NotNull
    private final Position position;
    @NotNull
    private final String contentType;

    RecordedEvent(@NotNull String eventStreamId, @NotNull long streamRevision, @NotNull UUID eventId, @NotNull Position position, @NotNull Map<String, String> systemMetadata, @NotNull byte[] eventData, @NotNull byte[] userMetadata) {
        this.streamId = eventStreamId;
        this.revision = streamRevision;
        this.eventId = eventId;
        this.position = position;
        this.eventData = eventData;
        this.userMetadata = userMetadata;
        this.eventType = systemMetadata.get("type");
        this.contentType = systemMetadata.get("content-type");
        this.created = RecordedEvent.systemMetadataDateToInstant(systemMetadata.get("created"));
    }

    private static Instant systemMetadataDateToInstant(String timestamp) {
        long nanos = Long.parseLong(timestamp) * 100L;
        return Instant.EPOCH.plusNanos(nanos);
    }

    @NotNull
    public String getStreamId() {
        return this.streamId;
    }

    @NotNull
    public long getRevision() {
        return this.revision;
    }

    @NotNull
    public UUID getEventId() {
        return this.eventId;
    }

    @NotNull
    public String getEventType() {
        return this.eventType;
    }

    public byte[] getEventData() {
        return this.eventData;
    }

    public byte[] getUserMetadata() {
        return this.userMetadata;
    }

    @NotNull
    public Instant getCreated() {
        return this.created;
    }

    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordedEvent that = (RecordedEvent)o;
        return this.streamId.equals(that.streamId) && this.revision == that.revision && this.eventId.equals(that.eventId);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.revision, this.eventId);
    }

    static RecordedEvent fromWire(StreamsOuterClass.ReadResp.ReadEvent.RecordedEvent wireEvent) {
        UUID eventId;
        if (wireEvent.getId().hasStructured()) {
            Shared.UUID.Structured structured = wireEvent.getId().getStructured();
            eventId = new UUID(structured.getMostSignificantBits(), structured.getLeastSignificantBits());
        } else {
            eventId = UUID.fromString(wireEvent.getId().getString());
        }
        return new RecordedEvent(wireEvent.getStreamIdentifier().getStreamName().toStringUtf8(), wireEvent.getStreamRevision(), eventId, new Position(wireEvent.getCommitPosition(), wireEvent.getPreparePosition()), wireEvent.getMetadataMap(), wireEvent.getData().toByteArray(), wireEvent.getCustomMetadata().toByteArray());
    }

    static RecordedEvent fromWire(Persistent.ReadResp.ReadEvent.RecordedEvent wireEvent) {
        UUID eventId;
        if (wireEvent.getId().hasStructured()) {
            Shared.UUID.Structured structured = wireEvent.getId().getStructured();
            eventId = new UUID(structured.getMostSignificantBits(), structured.getLeastSignificantBits());
        } else {
            eventId = UUID.fromString(wireEvent.getId().getString());
        }
        return new RecordedEvent(wireEvent.getStreamIdentifier().getStreamName().toStringUtf8(), wireEvent.getStreamRevision(), eventId, new Position(wireEvent.getCommitPosition(), wireEvent.getPreparePosition()), wireEvent.getMetadataMap(), wireEvent.getData().toByteArray(), wireEvent.getCustomMetadata().toByteArray());
    }

    public String toString() {
        return "RecordedEvent{streamId='" + this.streamId + '\'' + ", revision=" + this.revision + ", eventId=" + this.eventId + ", eventType='" + this.eventType + '\'' + ", eventData=" + Arrays.toString(this.eventData) + ", userMetadata=" + Arrays.toString(this.userMetadata) + ", created=" + this.created + ", position=" + this.position + ", contentType='" + this.contentType + '\'' + '}';
    }
}

