/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.HttpUtils;
import io.kurrent.dbclient.ReplayParkedMessagesOptions;
import io.kurrent.dbclient.UnsupportedFeatureException;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.CompletableFuture;

final class ReplayParkedMessages {
    ReplayParkedMessages() {
    }

    public static CompletableFuture execute(GrpcClient client, ReplayParkedMessagesOptions options, String stream, String groupName) {
        return client.runWithArgs(args -> {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            if (stream.equals("$all") && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
                return result;
            }
            if (args.supportFeature(30)) {
                Persistent.ReplayParkedReq.Options.Builder optionBuilder = Persistent.ReplayParkedReq.Options.newBuilder();
                if (stream.equals("$all")) {
                    optionBuilder.setAll(Shared.Empty.getDefaultInstance());
                } else {
                    optionBuilder.setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)stream)));
                }
                optionBuilder.setGroupName(groupName);
                if (options.getStopAt() != null) {
                    optionBuilder.setStopAt(options.getStopAt());
                } else {
                    optionBuilder.setNoLimit(Shared.Empty.getDefaultInstance());
                }
                Persistent.ReplayParkedReq req = Persistent.ReplayParkedReq.newBuilder().setOptions(optionBuilder).build();
                PersistentSubscriptionsGrpc.PersistentSubscriptionsStub stub = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), client.getSettings(), options);
                stub.replayParked(req, (StreamObserver<Persistent.ReplayParkedResp>)GrpcUtils.convertSingleResponse(result, resp -> 42));
            } else {
                String query = options.getStopAt() != null ? String.format("?stopAt=%s", options.getStopAt()) : "";
                HttpURLConnection http = args.getHttpConnection(options, client.getSettings(), String.format("/subscriptions/%s/%s/replayParked%s", HttpUtils.urlEncode(stream), HttpUtils.urlEncode(groupName), query));
                try {
                    http.setDoOutput(true);
                    http.setRequestMethod("POST");
                    http.setFixedLengthStreamingMode(0);
                    Exception error = HttpUtils.checkForError(http.getResponseCode());
                    if (error != null) {
                        result.completeExceptionally(error);
                    } else {
                        result.complete(42);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    http.disconnect();
                }
            }
            return result;
        });
    }
}

