/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.ServerInfo;
import io.kurrent.dbclient.ServerVersion;
import io.kurrent.dbclient.proto.serverfeatures.ServerFeaturesGrpc;
import io.kurrent.dbclient.proto.serverfeatures.Serverfeatures;
import io.kurrent.dbclient.proto.shared.Shared;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

class ServerFeatures {
    ServerFeatures() {
    }

    public static Optional<ServerInfo> getSupportedFeatures(KurrentDBClientSettings settings, ManagedChannel channel) {
        ServerFeaturesGrpc.ServerFeaturesStub stub = ServerFeaturesGrpc.newStub((Channel)channel);
        try {
            return Optional.ofNullable(ServerFeatures.getSupportedFeaturesInternal(stub).get(settings.getGossipTimeout(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted when fetching server features", e);
        }
        catch (TimeoutException e) {
            throw new RetryableException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof StatusRuntimeException) {
                StatusRuntimeException error = (StatusRuntimeException)e.getCause();
                if (error.getStatus().getCode() == Status.Code.NOT_FOUND || error.getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                    return Optional.empty();
                }
                if (error.getStatus().getCode() == Status.Code.UNAVAILABLE) {
                    throw new RetryableException(e);
                }
            }
            throw new RuntimeException("Error when fetching server features", e);
        }
    }

    private static CompletableFuture<ServerInfo> getSupportedFeaturesInternal(ServerFeaturesGrpc.ServerFeaturesStub stub) {
        CompletableFuture<ServerInfo> result = new CompletableFuture<ServerInfo>();
        stub.getSupportedMethods(Shared.Empty.getDefaultInstance(), (StreamObserver<Serverfeatures.SupportedMethods>)ServerFeatures.convertSingleResponse(result, resp -> {
            int major = 0;
            int minor = 0;
            int patch = 0;
            String semVer = resp.getEventStoreServerVersion().replaceAll("[^.\\d]+", "");
            String[] splits = semVer.split("\\.");
            block18: for (int idx = 0; idx < splits.length && idx <= 2; ++idx) {
                int value = Integer.parseInt(splits[idx]);
                switch (idx) {
                    case 0: {
                        major = value;
                        continue block18;
                    }
                    case 1: {
                        minor = value;
                        continue block18;
                    }
                    default: {
                        patch = value;
                    }
                }
            }
            ServerVersion version = new ServerVersion(major, minor, patch);
            int features = 0;
            block19: for (Serverfeatures.SupportedMethod method : resp.getMethodsList()) {
                if (method.getMethodName().equals("batchappend") && method.getServiceName().equals("event_store.client.streams.streams")) {
                    features |= 1;
                    continue;
                }
                if (!method.getServiceName().equals("event_store.client.persistent_subscriptions.persistentsubscriptions")) continue;
                switch (method.getMethodName()) {
                    case "create": {
                        for (String feat : method.getFeaturesList()) {
                            if (!feat.equals("all")) continue;
                            features |= 0x20;
                        }
                        continue block19;
                    }
                    case "getinfo": {
                        features |= 0x10;
                        break;
                    }
                    case "replayparked": {
                        features |= 4;
                        break;
                    }
                    case "list": {
                        features |= 2;
                        break;
                    }
                    case "restartsubsystem": {
                        features |= 8;
                        break;
                    }
                }
            }
            return new ServerInfo(version, features);
        }));
        return result;
    }

    private static <ReqT, RespT, TargetT> ClientResponseObserver<ReqT, RespT> convertSingleResponse(final CompletableFuture<TargetT> dest, final Function<RespT, TargetT> converter) {
        return new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            }

            public void onNext(RespT value) {
                try {
                    Object converted = converter.apply(value);
                    dest.complete(converted);
                }
                catch (Throwable e) {
                    dest.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                dest.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }

    static class RetryableException
    extends RuntimeException {
        public RetryableException(Throwable cause) {
            super(cause);
        }
    }
}

