/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import java.util.Optional;

public class StreamPosition<A> {
    public static <A> StreamPosition<A> start() {
        return new Start();
    }

    public static <A> StreamPosition<A> end() {
        return new End();
    }

    public static <A> StreamPosition<A> position(A position) {
        return new Position<A>(position);
    }

    StreamPosition() {
    }

    public boolean isStart() {
        return this instanceof Start;
    }

    public boolean isEnd() {
        return this instanceof End;
    }

    public Optional<A> getPosition() {
        if (this instanceof Position) {
            Position pos = (Position)this;
            return Optional.of(pos.getValue());
        }
        return Optional.empty();
    }

    public A getPositionOrThrow() {
        return this.getPosition().get();
    }

    static final class Position<A>
    extends StreamPosition<A> {
        private final A position;

        public Position(A position) {
            this.position = position;
        }

        public A getValue() {
            return this.position;
        }

        public String toString() {
            return this.position.toString();
        }
    }

    static final class End<A>
    extends StreamPosition<A> {
        End() {
        }

        public String toString() {
            return "End";
        }
    }

    static final class Start<A>
    extends StreamPosition<A> {
        Start() {
        }

        public String toString() {
            return "Start";
        }
    }
}

