/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient.resolution;

import io.kurrent.dbclient.Endpoint;
import io.kurrent.dbclient.resolution.NodeResolution;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeprecatedNodeResolution
implements NodeResolution {
    private final Endpoint address;

    public DeprecatedNodeResolution(Endpoint address) {
        this.address = address;
    }

    @Override
    public List<InetSocketAddress> resolve() {
        try {
            return Arrays.stream(InetAddress.getAllByName(this.address.getHost())).map(addr -> new InetSocketAddress((InetAddress)addr, this.address.getPort())).collect(Collectors.toList());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

