/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.sql.Connection;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.resolver.jdbc.JdbcMigrationResolver;
import org.flywaydb.core.internal.resolver.spring.SpringJdbcMigrationResolver;
import org.flywaydb.core.internal.resolver.spring.SpringJdbcMigrationResolverCustom;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.jdbc.JdbcUtils;
import org.flywaydb.core.internal.util.scanner.Scanner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={FlywayAutoConfiguration.class})
public class FlywayAutoConfigurationAfter {
    @Bean
    @ConditionalOnMissingBean(value={FlywayMigrationStrategy.class})
    public FlywayMigrationStrategy migrationStrategy(final ApplicationContext applicationContext) {
        return new FlywayMigrationStrategy(){

            public void migrate(Flyway flyway) {
                if (flyway.isSkipDefaultResolvers()) {
                    ArrayList<Object> migrationResolvers = new ArrayList<Object>();
                    DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)JdbcUtils.openConnection((DataSource)flyway.getDataSource()), (boolean)true);
                    Scanner scanner = new Scanner(flyway.getClassLoader());
                    Locations locations = new Locations(flyway.getLocations());
                    PlaceholderReplacer placeholderReplacer = flyway.isPlaceholderReplacement() ? new PlaceholderReplacer(flyway.getPlaceholders(), flyway.getPlaceholderPrefix(), flyway.getPlaceholderSuffix()) : PlaceholderReplacer.NO_PLACEHOLDERS;
                    migrationResolvers.add(new SqlMigrationResolver(dbSupport, scanner, locations, placeholderReplacer, (FlywayConfiguration)flyway));
                    migrationResolvers.add(new JdbcMigrationResolver(scanner, locations, (FlywayConfiguration)flyway));
                    if (new FeatureDetector(scanner.getClassLoader()).isSpringJdbcAvailable()) {
                        migrationResolvers.add(new SpringJdbcMigrationResolverCustom(scanner, locations, (FlywayConfiguration)flyway, applicationContext));
                        migrationResolvers.add(new SpringJdbcMigrationResolver(scanner, locations, (FlywayConfiguration)flyway));
                    }
                    flyway.setResolvers(migrationResolvers.toArray(new MigrationResolver[migrationResolvers.size()]));
                }
                flyway.migrate();
            }
        };
    }
}

