/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.spring.data.AuditableSerializer;
import com.fasterxml.jackson.datatype.spring.data.PersistableSerializer;
import com.fasterxml.jackson.datatype.spring.security.UserDetailsSerializer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Auditable;
import org.springframework.data.domain.Persistable;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class JacksonAutoConfigurationAfter {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer findModulesViaServiceLoader() {
        return new Jackson2ObjectMapperBuilderCustomizer(){

            public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
                jacksonObjectMapperBuilder.findModulesViaServiceLoader(true);
            }
        };
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer mixIn() {
        return new Jackson2ObjectMapperBuilderCustomizer(){

            public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
                if (ClassUtils.isPresent((String)"org.springframework.data.domain.Auditable", (ClassLoader)this.getClass().getClassLoader())) {
                    jacksonObjectMapperBuilder.mixIn(Auditable.class, AuditableSerializer.class);
                }
                if (ClassUtils.isPresent((String)"org.springframework.data.domain.Persistable", (ClassLoader)this.getClass().getClassLoader())) {
                    jacksonObjectMapperBuilder.mixIn(Persistable.class, PersistableSerializer.class);
                }
                if (ClassUtils.isPresent((String)"org.springframework.security.core.userdetails.UserDetails", (ClassLoader)this.getClass().getClassLoader())) {
                    jacksonObjectMapperBuilder.mixIn(UserDetails.class, UserDetailsSerializer.class);
                }
            }
        };
    }
}

