/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mobile;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mobile.DeviceDelegatingViewResolverAutoConfiguration;
import org.springframework.boot.autoconfigure.mobile.DeviceDelegatingViewResolverFactory;
import org.springframework.boot.autoconfigure.mobile.DeviceDelegatingViewResolverProperties;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.mobile.device.view.LiteDeviceDelegatingViewResolver;
import org.springframework.web.servlet.ViewResolver;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={LiteDeviceDelegatingViewResolver.class})
@ConditionalOnProperty(prefix="spring.mobile.devicedelegatingviewresolver", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={DeviceDelegatingViewResolverAutoConfiguration.class})
public class DeviceDelegatingViewResolverAutoConfigurationAfter {

    @Configuration
    protected static class LiteDeviceDelegatingViewResolverFactoryConfigurationCustom {
        protected LiteDeviceDelegatingViewResolverFactoryConfigurationCustom() {
        }

        @Bean
        @Primary
        public DeviceDelegatingViewResolverFactory deviceDelegatingViewResolverFactoryCustom(final DeviceDelegatingViewResolverProperties properties) {
            return new DeviceDelegatingViewResolverFactory(properties){

                public LiteDeviceDelegatingViewResolver createViewResolver(ViewResolver delegate, int delegatingOrder) {
                    LiteDeviceDelegatingViewResolver resolver = new LiteDeviceDelegatingViewResolver(delegate){
                        private TemplateAvailabilityProviders templateAvailabilityProviders;

                        protected String getDeviceViewName(String viewName) {
                            String deviceViewName = super.getDeviceViewName(viewName);
                            return this.getEnableFallback() && this.templateAvailabilityProviders.getProvider(deviceViewName, this.getApplicationContext()) == null ? viewName : deviceViewName;
                        }

                        protected void initApplicationContext(ApplicationContext context) {
                            super.initApplicationContext(context);
                            this.templateAvailabilityProviders = new TemplateAvailabilityProviders(context);
                        }
                    };
                    resolver.setEnableFallback(properties.isEnableFallback());
                    resolver.setNormalPrefix(properties.getNormalPrefix());
                    resolver.setNormalSuffix(properties.getNormalSuffix());
                    resolver.setMobilePrefix(properties.getMobilePrefix());
                    resolver.setMobileSuffix(properties.getMobileSuffix());
                    resolver.setTabletPrefix(properties.getTabletPrefix());
                    resolver.setTabletSuffix(properties.getTabletSuffix());
                    resolver.setOrder(delegatingOrder);
                    return resolver;
                }
            };
        }
    }
}

