/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EntityManager.class})
@Conditional(value={HibernateJpaAutoConfiguration.HibernateEntityManagerCondition.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@ConfigurationProperties(prefix="spring.jpa.hibernate")
public class HibernateJpaAutoConfigurationAfter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<Database, Class<? extends Dialect>> dialect = new LinkedHashMap<Database, Class<? extends Dialect>>();

    @Bean
    public JpaVendorAdapter jpaVendorAdapter(JpaProperties jpaProperties, DataSource dataSource) {
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter(){

            protected Class<?> determineDatabaseDialectClass(Database database) {
                Class dialectClass = (Class)HibernateJpaAutoConfigurationAfter.this.dialect.get(database);
                if (dialectClass == null) {
                    dialectClass = super.determineDatabaseDialectClass(database);
                }
                return dialectClass;
            }
        };
        adapter.setDatabase(jpaProperties.determineDatabase(dataSource));
        adapter.setShowSql(jpaProperties.isShowSql());
        adapter.setGenerateDdl(jpaProperties.isGenerateDdl());
        adapter.setDatabasePlatform(jpaProperties.getDatabasePlatform());
        return adapter;
    }

    @Bean
    public Database database(JpaVendorAdapter jpaVendorAdapter) {
        Method method;
        if (jpaVendorAdapter instanceof AbstractJpaVendorAdapter && (method = ReflectionUtils.findMethod(jpaVendorAdapter.getClass(), (String)"getDatabase")) != null) {
            ReflectionUtils.makeAccessible((Method)method);
            Object object = ReflectionUtils.invokeMethod((Method)method, (Object)jpaVendorAdapter);
            if (object instanceof Database) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Database: " + object));
                }
                return (Database)object;
            }
        }
        return Database.DEFAULT;
    }

    public Map<Database, Class<? extends Dialect>> getDialect() {
        return this.dialect;
    }

    public void setDialect(Map<Database, Class<? extends Dialect>> dialect) {
        this.dialect = dialect;
    }
}

