/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Arrays;
import javax.persistence.EntityManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaSearchListener;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EntityManager.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@Conditional(value={HibernateFullTextEntityManagerCondition.class, HibernateJpaAutoConfiguration.HibernateEntityManagerCondition.class})
public class HibernateJpaSearchAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.jpa.hibernate.search")
    @ConditionalOnProperty(prefix="spring.jpa.hibernate.search", name={"enabled"}, matchIfMissing=true)
    public HibernateJpaSearchListener hibernateJpaSearchListener() {
        return new HibernateJpaSearchListener();
    }

    @Order(value=-2147483628)
    static class HibernateFullTextEntityManagerCondition
    extends SpringBootCondition {
        private static String[] CLASS_NAMES = new String[]{"org.hibernate.search.jpa.FullTextEntityManager"};

        HibernateFullTextEntityManagerCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"FullTextEntityManager", (Object[])new Object[0]);
            for (String className : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match((ConditionMessage)message.found("class").items(ConditionMessage.Style.QUOTE, new Object[]{className}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("class", "classes").items(ConditionMessage.Style.QUOTE, Arrays.asList(CLASS_NAMES)));
        }
    }
}

