/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.search.jpa.Search;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.SystemPropertyUtils;

class HibernateJpaSearchListener
implements ApplicationListener<ApplicationReadyEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String lineSeparator = SystemPropertyUtils.resolvePlaceholders((String)"${line.separator:\r\n}");
    private Set<String> excludes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    HibernateJpaSearchListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map map = event.getApplicationContext().getBeansOfType(EntityManager.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
        calendar.setTimeInMillis(event.getTimestamp());
        StopWatch stopWatch = new StopWatch(DatatypeConverter.printDateTime((Calendar)calendar));
        for (Map.Entry entry : map.entrySet()) {
            EntityManager entityManager = (EntityManager)entry.getValue();
            Object persistenceUnitName = entityManager.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName");
            if (this.excludes.contains(persistenceUnitName)) continue;
            Object dataSource = entityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource");
            if (dataSource instanceof DataSource) {
                try {
                    dataSource = JdbcUtils.extractDatabaseMetaData((DataSource)((DataSource)dataSource), (String)"getURL");
                }
                catch (MetaDataAccessException metaDataAccessException) {
                    // empty catch block
                }
            }
            StringBuilder stringBuilder = new StringBuilder((String)entry.getKey());
            if (persistenceUnitName instanceof String) {
                stringBuilder.append(this.lineSeparator);
                stringBuilder.append("persistenceUnitName: ");
                stringBuilder.append(persistenceUnitName);
            }
            if (dataSource instanceof String) {
                stringBuilder.append(this.lineSeparator);
                stringBuilder.append("dataSource: ");
                stringBuilder.append(dataSource);
            }
            stopWatch.start(new String(stringBuilder));
            try {
                Search.getFullTextEntityManager((EntityManager)entityManager).createIndexer(new Class[0]).startAndWait();
            }
            catch (IllegalArgumentException | InterruptedException | NoClassDefFoundError e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("An error occurred trying to build the search index: " + e), e);
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("An error occurred trying to build the search index: " + e));
            }
            finally {
                stopWatch.stop();
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)stopWatch.prettyPrint());
        }
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }
}

