/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializationFailedException;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.session.Session;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HeaderHttpSessionStrategy;

@Configuration
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={SessionAutoConfiguration.class})
public class SessionAutoConfigurationAfter
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    @Bean
    public ConversionService springSessionConversionService() {
        GenericConversionService genericConversionService = new GenericConversionService();
        genericConversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter(){

            public byte[] convert(Object source) {
                try {
                    return super.convert(source);
                }
                catch (SerializationFailedException e) {
                    return new byte[0];
                }
            }
        });
        genericConversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader != null ? this.classLoader : this.getClass().getClassLoader()){

            public Object convert(byte[] source) {
                try {
                    return super.convert(source);
                }
                catch (SerializationFailedException e) {
                    return null;
                }
            }
        });
        return genericConversionService;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public static class RedisSessionConfigurationCustom
    implements BeanClassLoaderAware {
        private ClassLoader classLoader;

        @Bean
        public RedisSerializer<Object> springSessionDefaultRedisSerializer() {
            return new JdkSerializationRedisSerializer(this.classLoader != null ? this.classLoader : this.getClass().getClassLoader()){

                public Object deserialize(byte[] bytes) {
                    try {
                        return super.deserialize(bytes);
                    }
                    catch (SerializationException e) {
                        return null;
                    }
                }

                public byte[] serialize(Object object) {
                    try {
                        return super.serialize(object);
                    }
                    catch (SerializationException e) {
                        return new byte[0];
                    }
                }
            };
        }

        public void setBeanClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="session.cookie", name={"enabled"}, havingValue="false", matchIfMissing=false)
    public static class HeaderAutoConfiguration {
        @Bean
        @ConfigurationProperties(value="session.http-session-strategy")
        public HeaderHttpSessionStrategy httpSessionStrategy() {
            HeaderHttpSessionStrategy headerHttpSessionStrategy = new HeaderHttpSessionStrategy();
            return headerHttpSessionStrategy;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="session.cookie", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class CookieAutoConfiguration {
        @Bean
        @ConfigurationProperties(value="session.http-session-strategy")
        public CookieHttpSessionStrategy httpSessionStrategy(ObjectProvider<CookieSerializer> objectProvider) {
            CookieHttpSessionStrategy cookieHttpSessionStrategy = new CookieHttpSessionStrategy();
            CookieSerializer cookieSerializer = (CookieSerializer)objectProvider.getIfAvailable();
            if (cookieSerializer != null) {
                cookieHttpSessionStrategy.setCookieSerializer(cookieSerializer);
            }
            return cookieHttpSessionStrategy;
        }

        @Bean
        @ConfigurationProperties(value="session.cookie-serializer")
        @ConditionalOnProperty(prefix="session.cookie-serializer", name={"enabled"}, matchIfMissing=true)
        public DefaultCookieSerializer cookieSerializer(ServerProperties serverProperties) {
            DefaultCookieSerializer defaultCookieSerializer = new DefaultCookieSerializer();
            ServerProperties.Session.Cookie cookie = serverProperties.getSession().getCookie();
            if (cookie.getName() != null) {
                defaultCookieSerializer.setCookieName(cookie.getName());
            }
            if (cookie.getDomain() != null) {
                defaultCookieSerializer.setDomainName(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                defaultCookieSerializer.setCookiePath(cookie.getPath());
            }
            if (cookie.getHttpOnly() != null) {
                defaultCookieSerializer.setUseHttpOnlyCookie(cookie.getHttpOnly().booleanValue());
            }
            if (cookie.getSecure() != null) {
                defaultCookieSerializer.setUseSecureCookie(cookie.getSecure().booleanValue());
            }
            if (cookie.getMaxAge() != null) {
                defaultCookieSerializer.setCookieMaxAge(cookie.getMaxAge().intValue());
            }
            if (cookie.getComment() != null) {
                // empty if block
            }
            return defaultCookieSerializer;
        }
    }
}

