/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.validation;

import javax.validation.executable.ExecutableValidator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@ConditionalOnClass(value={ExecutableValidator.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
@AutoConfigureBefore(value={ValidationAutoConfiguration.class})
public class ValidationAutoConfigurationBefore {
    @Bean
    @Role(value=2)
    public static LocalValidatorFactoryBean defaultValidator(MessageSource messageSource) {
        StaticMessageSource staticMessageSource = new StaticMessageSource();
        staticMessageSource.setParentMessageSource(messageSource);
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        factoryBean.setMessageInterpolator(new MessageInterpolatorFactory().getObject());
        factoryBean.setValidationMessageSource((MessageSource)staticMessageSource);
        return factoryBean;
    }
}

