/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributesCustom;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ErrorViewResolver;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.ModelAndView;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureAfter(value={ErrorMvcAutoConfiguration.class})
@ConfigurationProperties(prefix="spring.error")
public class ErrorMvcAutoConfigurationAfter {
    private List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
    private final ServerProperties serverProperties;
    private final List<ErrorViewResolver> errorViewResolvers;

    public ErrorMvcAutoConfigurationAfter(ServerProperties serverProperties, ObjectProvider<List<ErrorViewResolver>> errorViewResolversProvider) {
        this.serverProperties = serverProperties;
        this.errorViewResolvers = (List)errorViewResolversProvider.getIfAvailable();
    }

    @Bean
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new BasicErrorController(errorAttributes, this.serverProperties.getError(), this.errorViewResolvers){

            @RequestMapping(produces={"text/html"})
            public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
                Map model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.TEXT_HTML)));
                HttpStatus status = this.getStatus(request);
                response.setStatus(status.value());
                ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
                return modelAndView == null ? new ModelAndView("error", model) : modelAndView;
            }
        };
    }

    @Bean
    public DefaultErrorAttributes errorAttributes(MessageSource messageSource) {
        return new DefaultErrorAttributesCustom(messageSource);
    }

    public List<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void setErrorPages(List<ErrorPage> errorPages) {
        this.errorPages = errorPages;
    }
}

