/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.http.client")
public class HttpClientProperties {
    private Proxy.Type type = Proxy.Type.DIRECT;
    private InetAddress address = InetAddress.getLoopbackAddress();
    private int port = -1;

    public Proxy.Type getType() {
        return this.type;
    }

    public void setType(Proxy.Type type) {
        this.type = type;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Proxy createProxy() {
        if (this.address == null) {
            return Proxy.NO_PROXY;
        }
        try {
            return new Proxy(this.type, InetSocketAddress.createUnresolved(this.address.getHostAddress(), this.port));
        }
        catch (IllegalArgumentException e) {
            return Proxy.NO_PROXY;
        }
    }
}

