/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.HttpEncodingProperties;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.BufferedImageHttpMessageConverterCustom;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.InputStreamHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverterCustom;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration
@ConditionalOnClass(value={HttpMessageConverter.class})
@AutoConfigureAfter(value={HttpMessageConvertersAutoConfiguration.class})
public class HttpMessageConvertersAutoConfigurationAfter {
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConvertersAutoConfigurationAfter(ObjectProvider<List<HttpMessageConverter<?>>> convertersProvider) {
        this.converters = convertersProvider.getIfAvailable() == null ? Collections.emptyList() : (List)convertersProvider.getIfAvailable();
    }

    @Bean
    public HttpMessageConverters messageConverters() {
        ArrayList<Object> converters = new ArrayList<Object>();
        for (HttpMessageConverter<?> next : new HttpMessageConverters(new HttpMessageConverter[0]).getConverters()) {
            if (next instanceof StringHttpMessageConverter || next instanceof AbstractXmlHttpMessageConverter || next instanceof MappingJackson2XmlHttpMessageConverter || next instanceof AbstractJackson2HttpMessageConverter || next instanceof GsonHttpMessageConverter) continue;
            converters.add(next);
        }
        for (HttpMessageConverter<?> next : this.converters) {
            if (!(next instanceof StringHttpMessageConverter)) continue;
            converters.add(1, next);
        }
        converters.add(new InputStreamHttpMessageConverter());
        converters.add(new BufferedImageHttpMessageConverterCustom());
        for (HttpMessageConverter<?> next : this.converters) {
            if (next instanceof AbstractJackson2HttpMessageConverter) {
                converters.add(next);
            }
            if (!(next instanceof GsonHttpMessageConverter)) continue;
            converters.add(next);
        }
        converters.add(new Jaxb2RootElementHttpMessageConverter());
        return new HttpMessageConverters(false, converters);
    }

    @Configuration
    @ConditionalOnClass(value={StringHttpMessageConverter.class, Jsoup.class})
    protected static class StringHttpMessageConverterConfigurationCustom {
        private final HttpEncodingProperties encodingProperties;

        protected StringHttpMessageConverterConfigurationCustom(HttpEncodingProperties encodingProperties) {
            this.encodingProperties = encodingProperties;
        }

        @Bean
        @Primary
        public StringHttpMessageConverter stringHttpMessageConverter() {
            StringHttpMessageConverterCustom converter = new StringHttpMessageConverterCustom(this.encodingProperties.getCharset());
            converter.setWriteAcceptCharset(false);
            return converter;
        }
    }
}

