/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.MultipartAutoConfiguration;
import org.springframework.boot.autoconfigure.web.MultipartProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.filter.OrderedMultipartFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.ExtensionUnsupportedException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Configuration
@ConditionalOnClass(value={Servlet.class, StandardServletMultipartResolver.class, MultipartConfigElement.class})
@ConditionalOnProperty(prefix="spring.http.multipart", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={MultipartAutoConfiguration.class})
public class MultipartAutoConfigurationAfter {
    @Primary
    @ConfigurationProperties(value="spring.multipart")
    @Bean(name={"multipartResolver"})
    public MultipartResolver multipartResolver(MultipartProperties multipartProperties) {
        StandardServletMultipartResolver multipartResolver = new StandardServletMultipartResolver(){
            private List<String> allows = new ArrayList<String>();
            private List<String> denys = new ArrayList<String>();

            public boolean isMultipart(HttpServletRequest request) {
                if (!"post".equalsIgnoreCase(request.getMethod()) && !"put".equalsIgnoreCase(request.getMethod())) {
                    return false;
                }
                String contentType = request.getContentType();
                return contentType != null && contentType.toLowerCase().startsWith("multipart/");
            }

            public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
                MultipartHttpServletRequest multipartHttpServletRequest = super.resolveMultipart(request);
                for (Map.Entry entry : multipartHttpServletRequest.getMultiFileMap().entrySet()) {
                    for (MultipartFile multipartFile : (List)entry.getValue()) {
                        String extension = StringUtils.getFilenameExtension((String)multipartFile.getOriginalFilename());
                        if (StringUtils.hasText((String)extension) && !CollectionUtils.isEmpty(this.allows) && !this.allows.contains(extension.toLowerCase())) {
                            throw new ExtensionUnsupportedException(extension);
                        }
                        if (!StringUtils.hasText((String)extension) || CollectionUtils.isEmpty(this.denys) || !this.denys.contains(extension.toLowerCase())) continue;
                        throw new ExtensionUnsupportedException(extension);
                    }
                }
                return multipartHttpServletRequest;
            }

            public List<String> getAllows() {
                return this.allows;
            }

            public void setAllows(List<String> allows) {
                this.allows = allows;
            }

            public List<String> getDenys() {
                return this.denys;
            }

            public void setDenys(List<String> denys) {
                this.denys = denys;
            }
        };
        multipartResolver.setResolveLazily(multipartProperties.isResolveLazily());
        return multipartResolver;
    }

    @Bean
    @ConfigurationProperties(value="spring.multipart.filter")
    @ConditionalOnProperty(prefix="spring.multipart.filter", name={"enabled"}, matchIfMissing=true)
    public OrderedMultipartFilter multipartFilter(@Qualifier(value="multipartResolver") MultipartResolver multipartResolver) {
        OrderedMultipartFilter multipartFilter = new OrderedMultipartFilter(multipartResolver);
        return multipartFilter;
    }
}

