/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.HttpClientProperties;
import org.springframework.boot.autoconfigure.web.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactoryCustom;
import org.springframework.http.client.LoggingClientHttpRequestInterceptor;
import org.springframework.http.client.ResponseErrorHandlerCustom;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={WebClientAutoConfiguration.class})
public class WebClientAutoConfigurationAfter {

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class})
    @AutoConfigureBefore(value={WebClientAutoConfiguration.RestTemplateConfiguration.class})
    @EnableConfigurationProperties(value={HttpClientProperties.class})
    public static class RestTemplateConfigurationCustom {
        private final HttpClientProperties clientProperties;

        public RestTemplateConfigurationCustom(HttpClientProperties clientProperties) {
            this.clientProperties = clientProperties;
        }

        @Bean
        public RestTemplateCustomizer clientHttpRequestFactory() {
            return new RestTemplateCustomizer(){

                public void customize(RestTemplate restTemplate) {
                    ClientHttpRequestFactoryCustom clientHttpRequestFactory = new ClientHttpRequestFactoryCustom();
                    clientHttpRequestFactory.setProxy(clientProperties.createProxy());
                    restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory));
                }
            };
        }

        @Bean
        public RestTemplateCustomizer clientHttpRequestInterceptor() {
            return new RestTemplateCustomizer(){

                public void customize(RestTemplate restTemplate) {
                    LoggingClientHttpRequestInterceptor interceptor = new LoggingClientHttpRequestInterceptor();
                    interceptor.setStatus(HttpStatus.NOT_FOUND);
                    restTemplate.getInterceptors().addAll(new LinkedHashSet<LoggingClientHttpRequestInterceptor>(Arrays.asList(interceptor)));
                }
            };
        }

        @Bean
        public RestTemplateCustomizer responseErrorHandler() {
            return new RestTemplateCustomizer(){

                public void customize(RestTemplate restTemplate) {
                    ResponseErrorHandlerCustom errorHandler = new ResponseErrorHandlerCustom();
                    errorHandler.setStatus(new HttpStatus[]{HttpStatus.BAD_REQUEST});
                    restTemplate.setErrorHandler((ResponseErrorHandler)errorHandler);
                }
            };
        }
    }
}

