/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ControllerProperties;
import org.springframework.boot.autoconfigure.web.CorsProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.filter.OrderedForwardedHeaderFilter;
import org.springframework.boot.web.filter.OrderedInspectionFilter;
import org.springframework.boot.web.filter.OrderedMultipartFilter;
import org.springframework.boot.web.filter.OrderedTimeZoneAwareLocaleChangeFilter;
import org.springframework.boot.web.filter.OrderedTraceFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.StringToEnumConverter;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.method.annotation.DimensionArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.RedirectViewControllerRegistration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.JsonpResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.MediaTypeResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.PageResponseBodyAdvice;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
@AutoConfigureOrder(value=-2147483643)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class WebMvcAutoConfigurationAfter {
    @Bean
    @ConfigurationProperties(value="spring.mvc.filter.trace-filter")
    @ConditionalOnProperty(prefix="spring.mvc.filter.trace-filter", name={"enabled"}, matchIfMissing=true)
    public OrderedTraceFilter traceFilter() {
        OrderedTraceFilter orderedTraceFilter = new OrderedTraceFilter();
        return orderedTraceFilter;
    }

    @Bean
    @ConfigurationProperties(value="spring.mvc.filter.inspection")
    public OrderedInspectionFilter inspectionFilter() {
        OrderedInspectionFilter orderedInspectionFilter = new OrderedInspectionFilter();
        return orderedInspectionFilter;
    }

    @Bean
    @ConditionalOnBean(value={MultipartResolver.class})
    @ConfigurationProperties(value="spring.mvc.filter.multipart-filter")
    @ConditionalOnProperty(prefix="spring.mvc.filter.multipart-filter", name={"enabled"}, matchIfMissing=true)
    public OrderedMultipartFilter multipartFilter(ApplicationContext applicationContext) {
        Object[] beanNames = applicationContext.getBeanNamesForType(MultipartResolver.class);
        Assert.notEmpty((Object[])beanNames, (String)"No MultipartResolver found: not in a DispatcherServlet request?");
        Assert.isTrue((beanNames.length < 2 ? 1 : 0) != 0, (String)("Multiple MultipartResolver found: in a DispatcherServlet request? " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames)));
        OrderedMultipartFilter multipartFilter = new OrderedMultipartFilter(null);
        multipartFilter.setMultipartResolverBeanName((String)beanNames[0]);
        return multipartFilter;
    }

    @Bean
    @ConditionalOnBean(value={LocaleResolver.class})
    @ConfigurationProperties(value="spring.mvc.filter.time-zone-aware-locale-change-filter")
    @ConditionalOnProperty(prefix="spring.mvc.filter.time-zone-aware-locale-change-filter", name={"enabled"}, matchIfMissing=true)
    public OrderedTimeZoneAwareLocaleChangeFilter timeZoneAwareLocaleChangeFilter(ApplicationContext applicationContext) {
        Object[] beanNames = applicationContext.getBeanNamesForType(LocaleResolver.class);
        Assert.notEmpty((Object[])beanNames, (String)"No LocaleResolver found: not in a DispatcherServlet request?");
        Assert.isTrue((beanNames.length < 2 ? 1 : 0) != 0, (String)("Multiple LocaleResolver found: in a ApplicationContext " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames)));
        OrderedTimeZoneAwareLocaleChangeFilter filter = new OrderedTimeZoneAwareLocaleChangeFilter();
        filter.setLocaleResolverBeanName((String)beanNames[0]);
        return filter;
    }

    @Bean
    @ConfigurationProperties(value="spring.mvc.filter.forwarded-header-filter")
    @ConditionalOnProperty(prefix="spring.mvc.filter.forwarded-header-filter", name={"enabled"}, matchIfMissing=true)
    public OrderedForwardedHeaderFilter forwardedHeaderFilter() {
        OrderedForwardedHeaderFilter forwardedHeaderFilter = new OrderedForwardedHeaderFilter();
        return forwardedHeaderFilter;
    }

    @Bean
    @ConfigurationProperties(value="spring.mvc.advice.media-type-response-body")
    @ConditionalOnProperty(prefix="spring.mvc.advice.media-type-response-body", name={"enabled"}, matchIfMissing=true)
    public MediaTypeResponseBodyAdvice mediaTypeResponseBodyAdvice() {
        return new MediaTypeResponseBodyAdvice();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Page"})
    @ConfigurationProperties(value="spring.mvc.advice.page-response-body")
    @ConditionalOnProperty(prefix="spring.mvc.advice.page-response-body", name={"enabled"}, matchIfMissing=true)
    public PageResponseBodyAdvice pageResponseBodyAdvice() {
        return new PageResponseBodyAdvice();
    }

    @Bean
    @ConfigurationProperties(value="spring.mvc.advice.jsonp-response-body")
    @ConditionalOnProperty(prefix="spring.mvc.advice.jsonp-response-body", name={"enabled"}, matchIfMissing=true)
    public JsonpResponseBodyAdvice jsonpResponseBodyAdvice() {
        return new JsonpResponseBodyAdvice();
    }

    @Configuration
    @EnableConfigurationProperties(value={CorsProperties.class, ControllerProperties.class})
    public static class WebMvcAutoConfigurationAdapterCustom
    extends WebMvcConfigurerAdapter {
        private final CorsProperties corsProperties;
        private final ControllerProperties controllerProperties;
        private final MessageSource messageSource;
        private final AsyncTaskExecutor asyncTaskExecutor;
        private final List<HandlerMethodArgumentResolver> handlerMethodArgumentResolvers;

        public WebMvcAutoConfigurationAdapterCustom(MessageSource messageSource, ObjectProvider<AsyncTaskExecutor> asyncTaskExecutor, ObjectProvider<List<HandlerMethodArgumentResolver>> handlerMethodArgumentResolvers, CorsProperties corsProperties, ControllerProperties controllerProperties) {
            this.corsProperties = corsProperties;
            this.controllerProperties = controllerProperties;
            this.asyncTaskExecutor = (AsyncTaskExecutor)asyncTaskExecutor.getIfAvailable();
            this.messageSource = messageSource;
            this.handlerMethodArgumentResolvers = (List)handlerMethodArgumentResolvers.getIfAvailable();
        }

        public void addViewControllers(ViewControllerRegistry registry) {
            if (this.controllerProperties.isEnabled()) {
                for (Map.Entry<String, ControllerProperties.RedirectViewProperties> entry : this.controllerProperties.getRedirectView().entrySet()) {
                    ControllerProperties.RedirectViewProperties redirectViewProperties = entry.getValue();
                    RedirectViewControllerRegistration redirectView = registry.addRedirectViewController(entry.getKey(), redirectViewProperties.getRedirectUrl());
                    if (redirectViewProperties.getContextRelative() != null) {
                        redirectView.setContextRelative(redirectViewProperties.getContextRelative().booleanValue());
                    }
                    if (redirectViewProperties.getKeepQueryParams() != null) {
                        redirectView.setKeepQueryParams(redirectViewProperties.getKeepQueryParams().booleanValue());
                    }
                    if (redirectViewProperties.getHttpStatus() == null) continue;
                    redirectView.setStatusCode(redirectViewProperties.getHttpStatus());
                }
                for (Map.Entry<String, Object> entry : this.controllerProperties.getView().entrySet()) {
                    ControllerProperties.ViewProperties viewProperties = (ControllerProperties.ViewProperties)entry.getValue();
                    ViewControllerRegistration view = registry.addViewController(entry.getKey());
                    if (viewProperties.getHttpStatus() != null) {
                        view.setStatusCode(viewProperties.getHttpStatus());
                    }
                    view.setViewName(viewProperties.getViewName());
                }
                for (Map.Entry<String, Object> entry : this.controllerProperties.getStatus().entrySet()) {
                    registry.addStatusController(entry.getKey(), (HttpStatus)entry.getValue());
                }
                if (this.controllerProperties.getOrder() != null) {
                    registry.setOrder(this.controllerProperties.getOrder().intValue());
                }
            }
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            if (this.asyncTaskExecutor != null) {
                configurer.setTaskExecutor(this.asyncTaskExecutor);
            }
        }

        @Bean
        @ConfigurationProperties(value="spring.mvc.resolver.dimension-argument")
        public DimensionArgumentResolver dimensionArgumentResolver() {
            DimensionArgumentResolver dimensionArgumentResolver = new DimensionArgumentResolver();
            return dimensionArgumentResolver;
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            AntPathMatcher antPathMatcher = new AntPathMatcher();
            antPathMatcher.setCaseSensitive(false);
            configurer.setPathMatcher((PathMatcher)antPathMatcher);
            configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
            configurer.setUseTrailingSlashMatch(Boolean.valueOf(false));
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add((HandlerMethodArgumentResolver)this.dimensionArgumentResolver());
            if (this.handlerMethodArgumentResolvers != null) {
                for (HandlerMethodArgumentResolver resolver : this.handlerMethodArgumentResolvers) {
                    if (argumentResolvers.contains(resolver)) continue;
                    argumentResolvers.add(resolver);
                }
            }
        }

        public void addFormatters(FormatterRegistry registry) {
            registry.addConverterFactory(new ConverterFactory<String, Enum<?>>(){

                public <T extends Enum<?>> Converter<String, T> getConverter(Class<T> targetType) {
                    Class<T> enumType;
                    for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
                    }
                    Assert.notNull(enumType, (String)("The target type " + targetType.getName() + " does not refer to an enum"));
                    return new StringToEnumConverter(enumType);
                }
            });
        }

        public void addCorsMappings(CorsRegistry registry) {
            if (!StringUtils.hasText((String)this.corsProperties.getPathPattern()) && CollectionUtils.isEmpty(this.corsProperties.getAllowedOrigins())) {
                return;
            }
            CorsRegistration corsRegistration = registry.addMapping(this.corsProperties.getPathPattern());
            corsRegistration.allowedOrigins(this.corsProperties.getAllowedOrigins().toArray(new String[this.corsProperties.getAllowedOrigins().size()]));
            if (!CollectionUtils.isEmpty(this.corsProperties.getAllowedHeaders())) {
                corsRegistration.allowedHeaders(this.corsProperties.getAllowedHeaders().toArray(new String[this.corsProperties.getAllowedHeaders().size()]));
            }
            if (!CollectionUtils.isEmpty(this.corsProperties.getAllowedMethods())) {
                corsRegistration.allowedMethods(this.corsProperties.getAllowedMethods().toArray(new String[this.corsProperties.getAllowedMethods().size()]));
            }
            if (!CollectionUtils.isEmpty(this.corsProperties.getExposedHeaders())) {
                corsRegistration.exposedHeaders(this.corsProperties.getExposedHeaders().toArray(new String[this.corsProperties.getExposedHeaders().size()]));
            }
            if (this.corsProperties.getMaxAge() != null) {
                corsRegistration.maxAge(this.corsProperties.getMaxAge().longValue());
            }
            if (this.corsProperties.getAllowCredentials() != null) {
                corsRegistration.allowCredentials(this.corsProperties.getAllowCredentials().booleanValue());
            }
        }
    }
}

