/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.view;

import java.util.Map;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.util.HtmlUtils;

class ExpressionResolver
implements PropertyPlaceholderHelper.PlaceholderResolver {
    private final Map<String, Expression> expressions;
    private final EvaluationContext context;

    ExpressionResolver(Map<String, Expression> expressions, Map<String, ?> map) {
        this.expressions = expressions;
        this.context = this.getContext(map);
    }

    private EvaluationContext getContext(Map<String, ?> map) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        context.setRootObject(map);
        return context;
    }

    public String resolvePlaceholder(String placeholderName) {
        Expression expression = this.expressions.get(placeholderName);
        return this.escape(expression == null ? null : expression.getValue(this.context));
    }

    private String escape(Object value) {
        return HtmlUtils.htmlEscape((String)(value == null ? null : value.toString()));
    }
}

