/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.BranchCreation;
import io.lakefs.clients.api.model.DiffList;
import io.lakefs.clients.api.model.Ref;
import io.lakefs.clients.api.model.RefList;
import io.lakefs.clients.api.model.ResetCreation;
import io.lakefs.clients.api.model.RevertCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class BranchesApi {
    private ApiClient localVarApiClient;

    public BranchesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BranchesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createBranchCall(String repository, BranchCreation branchCreation, ApiCallback _callback) throws ApiException {
        BranchCreation localVarPostBody = branchCreation;
        String localVarPath = "/repositories/{repository}/branches".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/html", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBranchValidateBeforeCall(String repository, BranchCreation branchCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createBranch(Async)");
        }
        if (branchCreation == null) {
            throw new ApiException("Missing the required parameter 'branchCreation' when calling createBranch(Async)");
        }
        Call localVarCall = this.createBranchCall(repository, branchCreation, _callback);
        return localVarCall;
    }

    public String createBranch(String repository, BranchCreation branchCreation) throws ApiException {
        ApiResponse<String> localVarResp = this.createBranchWithHttpInfo(repository, branchCreation);
        return localVarResp.getData();
    }

    public ApiResponse<String> createBranchWithHttpInfo(String repository, BranchCreation branchCreation) throws ApiException {
        Call localVarCall = this.createBranchValidateBeforeCall(repository, branchCreation, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBranchAsync(String repository, BranchCreation branchCreation, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.createBranchValidateBeforeCall(repository, branchCreation, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteBranchCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBranchValidateBeforeCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteBranch(Async)");
        }
        Call localVarCall = this.deleteBranchCall(repository, branch, _callback);
        return localVarCall;
    }

    public void deleteBranch(String repository, String branch) throws ApiException {
        this.deleteBranchWithHttpInfo(repository, branch);
    }

    public ApiResponse<Void> deleteBranchWithHttpInfo(String repository, String branch) throws ApiException {
        Call localVarCall = this.deleteBranchValidateBeforeCall(repository, branch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBranchAsync(String repository, String branch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBranchValidateBeforeCall(repository, branch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call diffBranchCall(String repository, String branch, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/diff".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call diffBranchValidateBeforeCall(String repository, String branch, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling diffBranch(Async)");
        }
        Call localVarCall = this.diffBranchCall(repository, branch, after, amount, _callback);
        return localVarCall;
    }

    public DiffList diffBranch(String repository, String branch, String after, Integer amount) throws ApiException {
        ApiResponse<DiffList> localVarResp = this.diffBranchWithHttpInfo(repository, branch, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<DiffList> diffBranchWithHttpInfo(String repository, String branch, String after, Integer amount) throws ApiException {
        Call localVarCall = this.diffBranchValidateBeforeCall(repository, branch, after, amount, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call diffBranchAsync(String repository, String branch, String after, Integer amount, ApiCallback<DiffList> _callback) throws ApiException {
        Call localVarCall = this.diffBranchValidateBeforeCall(repository, branch, after, amount, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBranchCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchValidateBeforeCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getBranch(Async)");
        }
        Call localVarCall = this.getBranchCall(repository, branch, _callback);
        return localVarCall;
    }

    public Ref getBranch(String repository, String branch) throws ApiException {
        ApiResponse<Ref> localVarResp = this.getBranchWithHttpInfo(repository, branch);
        return localVarResp.getData();
    }

    public ApiResponse<Ref> getBranchWithHttpInfo(String repository, String branch) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repository, branch, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBranchAsync(String repository, String branch, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repository, branch, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listBranchesCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listBranchesValidateBeforeCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listBranches(Async)");
        }
        Call localVarCall = this.listBranchesCall(repository, prefix, after, amount, _callback);
        return localVarCall;
    }

    public RefList listBranches(String repository, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<RefList> localVarResp = this.listBranchesWithHttpInfo(repository, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<RefList> listBranchesWithHttpInfo(String repository, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listBranchesValidateBeforeCall(repository, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listBranchesAsync(String repository, String prefix, String after, Integer amount, ApiCallback<RefList> _callback) throws ApiException {
        Call localVarCall = this.listBranchesValidateBeforeCall(repository, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetBranchCall(String repository, String branch, ResetCreation resetCreation, ApiCallback _callback) throws ApiException {
        ResetCreation localVarPostBody = resetCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetBranchValidateBeforeCall(String repository, String branch, ResetCreation resetCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling resetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling resetBranch(Async)");
        }
        if (resetCreation == null) {
            throw new ApiException("Missing the required parameter 'resetCreation' when calling resetBranch(Async)");
        }
        Call localVarCall = this.resetBranchCall(repository, branch, resetCreation, _callback);
        return localVarCall;
    }

    public void resetBranch(String repository, String branch, ResetCreation resetCreation) throws ApiException {
        this.resetBranchWithHttpInfo(repository, branch, resetCreation);
    }

    public ApiResponse<Void> resetBranchWithHttpInfo(String repository, String branch, ResetCreation resetCreation) throws ApiException {
        Call localVarCall = this.resetBranchValidateBeforeCall(repository, branch, resetCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetBranchAsync(String repository, String branch, ResetCreation resetCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetBranchValidateBeforeCall(repository, branch, resetCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revertBranchCall(String repository, String branch, RevertCreation revertCreation, ApiCallback _callback) throws ApiException {
        RevertCreation localVarPostBody = revertCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/revert".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revertBranchValidateBeforeCall(String repository, String branch, RevertCreation revertCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling revertBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling revertBranch(Async)");
        }
        if (revertCreation == null) {
            throw new ApiException("Missing the required parameter 'revertCreation' when calling revertBranch(Async)");
        }
        Call localVarCall = this.revertBranchCall(repository, branch, revertCreation, _callback);
        return localVarCall;
    }

    public void revertBranch(String repository, String branch, RevertCreation revertCreation) throws ApiException {
        this.revertBranchWithHttpInfo(repository, branch, revertCreation);
    }

    public ApiResponse<Void> revertBranchWithHttpInfo(String repository, String branch, RevertCreation revertCreation) throws ApiException {
        Call localVarCall = this.revertBranchValidateBeforeCall(repository, branch, revertCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revertBranchAsync(String repository, String branch, RevertCreation revertCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revertBranchValidateBeforeCall(repository, branch, revertCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

