/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.treeverse.lakefs.clients.api.ApiCallback;
import io.treeverse.lakefs.clients.api.ApiClient;
import io.treeverse.lakefs.clients.api.ApiException;
import io.treeverse.lakefs.clients.api.ApiResponse;
import io.treeverse.lakefs.clients.api.Configuration;
import io.treeverse.lakefs.clients.api.Pair;
import io.treeverse.lakefs.clients.api.model.ActionRun;
import io.treeverse.lakefs.clients.api.model.ActionRunList;
import io.treeverse.lakefs.clients.api.model.HookRunList;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ActionsApi {
    private ApiClient localVarApiClient;

    public ActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getRunCall(String repository, String runId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{run_id\\}", this.localVarApiClient.escapeString(runId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunValidateBeforeCall(String repository, String runId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRun(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRun(Async)");
        }
        Call localVarCall = this.getRunCall(repository, runId, _callback);
        return localVarCall;
    }

    public ActionRun getRun(String repository, String runId) throws ApiException {
        ApiResponse<ActionRun> localVarResp = this.getRunWithHttpInfo(repository, runId);
        return localVarResp.getData();
    }

    public ApiResponse<ActionRun> getRunWithHttpInfo(String repository, String runId) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(repository, runId, null);
        Type localVarReturnType = new TypeToken<ActionRun>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunAsync(String repository, String runId, ApiCallback<ActionRun> _callback) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(repository, runId, _callback);
        Type localVarReturnType = new TypeToken<ActionRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRunHookOutputCall(String repository, String runId, String hookRunId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}/hooks/{hook_run_id}/output".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{run_id\\}", this.localVarApiClient.escapeString(runId.toString())).replaceAll("\\{hook_run_id\\}", this.localVarApiClient.escapeString(hookRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunHookOutputValidateBeforeCall(String repository, String runId, String hookRunId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRunHookOutput(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRunHookOutput(Async)");
        }
        if (hookRunId == null) {
            throw new ApiException("Missing the required parameter 'hookRunId' when calling getRunHookOutput(Async)");
        }
        Call localVarCall = this.getRunHookOutputCall(repository, runId, hookRunId, _callback);
        return localVarCall;
    }

    public File getRunHookOutput(String repository, String runId, String hookRunId) throws ApiException {
        ApiResponse<File> localVarResp = this.getRunHookOutputWithHttpInfo(repository, runId, hookRunId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getRunHookOutputWithHttpInfo(String repository, String runId, String hookRunId) throws ApiException {
        Call localVarCall = this.getRunHookOutputValidateBeforeCall(repository, runId, hookRunId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunHookOutputAsync(String repository, String runId, String hookRunId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRunHookOutputValidateBeforeCall(repository, runId, hookRunId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRepositoryRunsCall(String repository, String after, Integer amount, String branch, String commit, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (branch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("branch", branch));
        }
        if (commit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("commit", commit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRepositoryRunsValidateBeforeCall(String repository, String after, Integer amount, String branch, String commit, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listRepositoryRuns(Async)");
        }
        Call localVarCall = this.listRepositoryRunsCall(repository, after, amount, branch, commit, _callback);
        return localVarCall;
    }

    public ActionRunList listRepositoryRuns(String repository, String after, Integer amount, String branch, String commit) throws ApiException {
        ApiResponse<ActionRunList> localVarResp = this.listRepositoryRunsWithHttpInfo(repository, after, amount, branch, commit);
        return localVarResp.getData();
    }

    public ApiResponse<ActionRunList> listRepositoryRunsWithHttpInfo(String repository, String after, Integer amount, String branch, String commit) throws ApiException {
        Call localVarCall = this.listRepositoryRunsValidateBeforeCall(repository, after, amount, branch, commit, null);
        Type localVarReturnType = new TypeToken<ActionRunList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRepositoryRunsAsync(String repository, String after, Integer amount, String branch, String commit, ApiCallback<ActionRunList> _callback) throws ApiException {
        Call localVarCall = this.listRepositoryRunsValidateBeforeCall(repository, after, amount, branch, commit, _callback);
        Type localVarReturnType = new TypeToken<ActionRunList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRunHooksCall(String repository, String runId, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}/hooks".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{run_id\\}", this.localVarApiClient.escapeString(runId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRunHooksValidateBeforeCall(String repository, String runId, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listRunHooks(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling listRunHooks(Async)");
        }
        Call localVarCall = this.listRunHooksCall(repository, runId, after, amount, _callback);
        return localVarCall;
    }

    public HookRunList listRunHooks(String repository, String runId, String after, Integer amount) throws ApiException {
        ApiResponse<HookRunList> localVarResp = this.listRunHooksWithHttpInfo(repository, runId, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<HookRunList> listRunHooksWithHttpInfo(String repository, String runId, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listRunHooksValidateBeforeCall(repository, runId, after, amount, null);
        Type localVarReturnType = new TypeToken<HookRunList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRunHooksAsync(String repository, String runId, String after, Integer amount, ApiCallback<HookRunList> _callback) throws ApiException {
        Call localVarCall = this.listRunHooksValidateBeforeCall(repository, runId, after, amount, _callback);
        Type localVarReturnType = new TypeToken<HookRunList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

