/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.treeverse.lakefs.clients.api.ApiCallback;
import io.treeverse.lakefs.clients.api.ApiClient;
import io.treeverse.lakefs.clients.api.ApiException;
import io.treeverse.lakefs.clients.api.ApiResponse;
import io.treeverse.lakefs.clients.api.Configuration;
import io.treeverse.lakefs.clients.api.Pair;
import io.treeverse.lakefs.clients.api.model.StagingLocation;
import io.treeverse.lakefs.clients.api.model.StagingMetadata;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StagingApi {
    private ApiClient localVarApiClient;

    public StagingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StagingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getPhysicalAddressCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/backing".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPhysicalAddressValidateBeforeCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getPhysicalAddress(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getPhysicalAddress(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getPhysicalAddress(Async)");
        }
        Call localVarCall = this.getPhysicalAddressCall(repository, branch, path, _callback);
        return localVarCall;
    }

    public StagingLocation getPhysicalAddress(String repository, String branch, String path) throws ApiException {
        ApiResponse<StagingLocation> localVarResp = this.getPhysicalAddressWithHttpInfo(repository, branch, path);
        return localVarResp.getData();
    }

    public ApiResponse<StagingLocation> getPhysicalAddressWithHttpInfo(String repository, String branch, String path) throws ApiException {
        Call localVarCall = this.getPhysicalAddressValidateBeforeCall(repository, branch, path, null);
        Type localVarReturnType = new TypeToken<StagingLocation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPhysicalAddressAsync(String repository, String branch, String path, ApiCallback<StagingLocation> _callback) throws ApiException {
        Call localVarCall = this.getPhysicalAddressValidateBeforeCall(repository, branch, path, _callback);
        Type localVarReturnType = new TypeToken<StagingLocation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call linkPhysicalAddressCall(String repository, String branch, String path, StagingMetadata stagingMetadata, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        StagingMetadata localVarPostBody = stagingMetadata;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/backing".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call linkPhysicalAddressValidateBeforeCall(String repository, String branch, String path, StagingMetadata stagingMetadata, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling linkPhysicalAddress(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling linkPhysicalAddress(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling linkPhysicalAddress(Async)");
        }
        if (stagingMetadata == null) {
            throw new ApiException("Missing the required parameter 'stagingMetadata' when calling linkPhysicalAddress(Async)");
        }
        Call localVarCall = this.linkPhysicalAddressCall(repository, branch, path, stagingMetadata, _callback);
        return localVarCall;
    }

    public void linkPhysicalAddress(String repository, String branch, String path, StagingMetadata stagingMetadata) throws ApiException {
        this.linkPhysicalAddressWithHttpInfo(repository, branch, path, stagingMetadata);
    }

    public ApiResponse<Void> linkPhysicalAddressWithHttpInfo(String repository, String branch, String path, StagingMetadata stagingMetadata) throws ApiException {
        Call localVarCall = this.linkPhysicalAddressValidateBeforeCall(repository, branch, path, stagingMetadata, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call linkPhysicalAddressAsync(String repository, String branch, String path, StagingMetadata stagingMetadata, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.linkPhysicalAddressValidateBeforeCall(repository, branch, path, stagingMetadata, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

