/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.treeverse.lakefs.clients.api.model.StagingLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="information about uploaded object")
public class StagingMetadata {
    public static final String SERIALIZED_NAME_STAGING = "staging";
    @SerializedName(value="staging")
    private StagingLocation staging;
    public static final String SERIALIZED_NAME_CHECKSUM = "checksum";
    @SerializedName(value="checksum")
    private String checksum;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "size_bytes";
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    public static final String SERIALIZED_NAME_USER_METADATA = "user_metadata";
    @SerializedName(value="user_metadata")
    private Map<String, String> userMetadata = null;

    public StagingMetadata staging(StagingLocation staging) {
        this.staging = staging;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StagingLocation getStaging() {
        return this.staging;
    }

    public void setStaging(StagingLocation staging) {
        this.staging = staging;
    }

    public StagingMetadata checksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @ApiModelProperty(required=true, value="unique identifier of object content on backing store (typically ETag)")
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public StagingMetadata sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public StagingMetadata userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public StagingMetadata putUserMetadataItem(String key, String userMetadataItem) {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        this.userMetadata.put(key, userMetadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingMetadata stagingMetadata = (StagingMetadata)o;
        return Objects.equals(this.staging, stagingMetadata.staging) && Objects.equals(this.checksum, stagingMetadata.checksum) && Objects.equals(this.sizeBytes, stagingMetadata.sizeBytes) && Objects.equals(this.userMetadata, stagingMetadata.userMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.staging, this.checksum, this.sizeBytes, this.userMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StagingMetadata {\n");
        sb.append("    staging: ").append(this.toIndentedString(this.staging)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    userMetadata: ").append(this.toIndentedString(this.userMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

