/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.BranchCreation;
import io.lakefs.clients.sdk.model.CherryPickCreation;
import io.lakefs.clients.sdk.model.Commit;
import io.lakefs.clients.sdk.model.DiffList;
import io.lakefs.clients.sdk.model.Ref;
import io.lakefs.clients.sdk.model.RefList;
import io.lakefs.clients.sdk.model.ResetCreation;
import io.lakefs.clients.sdk.model.RevertCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class BranchesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BranchesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BranchesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cherryPickCall(String repository, String branch, CherryPickCreation cherryPickCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CherryPickCreation localVarPostBody = cherryPickCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/cherry-pick".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cherryPickValidateBeforeCall(String repository, String branch, CherryPickCreation cherryPickCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling cherryPick(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling cherryPick(Async)");
        }
        if (cherryPickCreation == null) {
            throw new ApiException("Missing the required parameter 'cherryPickCreation' when calling cherryPick(Async)");
        }
        return this.cherryPickCall(repository, branch, cherryPickCreation, _callback);
    }

    private ApiResponse<Commit> cherryPickWithHttpInfo(String repository, String branch, CherryPickCreation cherryPickCreation) throws ApiException {
        Call localVarCall = this.cherryPickValidateBeforeCall(repository, branch, cherryPickCreation, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cherryPickAsync(String repository, String branch, CherryPickCreation cherryPickCreation, ApiCallback<Commit> _callback) throws ApiException {
        Call localVarCall = this.cherryPickValidateBeforeCall(repository, branch, cherryPickCreation, _callback);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcherryPickRequest cherryPick(String repository, String branch, CherryPickCreation cherryPickCreation) {
        return new APIcherryPickRequest(repository, branch, cherryPickCreation);
    }

    private Call createBranchCall(String repository, BranchCreation branchCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BranchCreation localVarPostBody = branchCreation;
        String localVarPath = "/repositories/{repository}/branches".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/html", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBranchValidateBeforeCall(String repository, BranchCreation branchCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createBranch(Async)");
        }
        if (branchCreation == null) {
            throw new ApiException("Missing the required parameter 'branchCreation' when calling createBranch(Async)");
        }
        return this.createBranchCall(repository, branchCreation, _callback);
    }

    private ApiResponse<String> createBranchWithHttpInfo(String repository, BranchCreation branchCreation) throws ApiException {
        Call localVarCall = this.createBranchValidateBeforeCall(repository, branchCreation, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createBranchAsync(String repository, BranchCreation branchCreation, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.createBranchValidateBeforeCall(repository, branchCreation, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateBranchRequest createBranch(String repository, BranchCreation branchCreation) {
        return new APIcreateBranchRequest(repository, branchCreation);
    }

    private Call deleteBranchCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBranchValidateBeforeCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteBranch(Async)");
        }
        return this.deleteBranchCall(repository, branch, _callback);
    }

    private ApiResponse<Void> deleteBranchWithHttpInfo(String repository, String branch) throws ApiException {
        Call localVarCall = this.deleteBranchValidateBeforeCall(repository, branch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteBranchAsync(String repository, String branch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBranchValidateBeforeCall(repository, branch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteBranchRequest deleteBranch(String repository, String branch) {
        return new APIdeleteBranchRequest(repository, branch);
    }

    private Call diffBranchCall(String repository, String branch, String after, Integer amount, String prefix, String delimiter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/diff".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (delimiter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delimiter", delimiter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call diffBranchValidateBeforeCall(String repository, String branch, String after, Integer amount, String prefix, String delimiter, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling diffBranch(Async)");
        }
        return this.diffBranchCall(repository, branch, after, amount, prefix, delimiter, _callback);
    }

    private ApiResponse<DiffList> diffBranchWithHttpInfo(String repository, String branch, String after, Integer amount, String prefix, String delimiter) throws ApiException {
        Call localVarCall = this.diffBranchValidateBeforeCall(repository, branch, after, amount, prefix, delimiter, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call diffBranchAsync(String repository, String branch, String after, Integer amount, String prefix, String delimiter, ApiCallback<DiffList> _callback) throws ApiException {
        Call localVarCall = this.diffBranchValidateBeforeCall(repository, branch, after, amount, prefix, delimiter, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdiffBranchRequest diffBranch(String repository, String branch) {
        return new APIdiffBranchRequest(repository, branch);
    }

    private Call getBranchCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchValidateBeforeCall(String repository, String branch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getBranch(Async)");
        }
        return this.getBranchCall(repository, branch, _callback);
    }

    private ApiResponse<Ref> getBranchWithHttpInfo(String repository, String branch) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repository, branch, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getBranchAsync(String repository, String branch, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repository, branch, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetBranchRequest getBranch(String repository, String branch) {
        return new APIgetBranchRequest(repository, branch);
    }

    private Call listBranchesCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listBranchesValidateBeforeCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listBranches(Async)");
        }
        return this.listBranchesCall(repository, prefix, after, amount, _callback);
    }

    private ApiResponse<RefList> listBranchesWithHttpInfo(String repository, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listBranchesValidateBeforeCall(repository, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listBranchesAsync(String repository, String prefix, String after, Integer amount, ApiCallback<RefList> _callback) throws ApiException {
        Call localVarCall = this.listBranchesValidateBeforeCall(repository, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistBranchesRequest listBranches(String repository) {
        return new APIlistBranchesRequest(repository);
    }

    private Call resetBranchCall(String repository, String branch, ResetCreation resetCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetCreation localVarPostBody = resetCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetBranchValidateBeforeCall(String repository, String branch, ResetCreation resetCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling resetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling resetBranch(Async)");
        }
        if (resetCreation == null) {
            throw new ApiException("Missing the required parameter 'resetCreation' when calling resetBranch(Async)");
        }
        return this.resetBranchCall(repository, branch, resetCreation, _callback);
    }

    private ApiResponse<Void> resetBranchWithHttpInfo(String repository, String branch, ResetCreation resetCreation) throws ApiException {
        Call localVarCall = this.resetBranchValidateBeforeCall(repository, branch, resetCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call resetBranchAsync(String repository, String branch, ResetCreation resetCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetBranchValidateBeforeCall(repository, branch, resetCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIresetBranchRequest resetBranch(String repository, String branch, ResetCreation resetCreation) {
        return new APIresetBranchRequest(repository, branch, resetCreation);
    }

    private Call revertBranchCall(String repository, String branch, RevertCreation revertCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RevertCreation localVarPostBody = revertCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/revert".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revertBranchValidateBeforeCall(String repository, String branch, RevertCreation revertCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling revertBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling revertBranch(Async)");
        }
        if (revertCreation == null) {
            throw new ApiException("Missing the required parameter 'revertCreation' when calling revertBranch(Async)");
        }
        return this.revertBranchCall(repository, branch, revertCreation, _callback);
    }

    private ApiResponse<Void> revertBranchWithHttpInfo(String repository, String branch, RevertCreation revertCreation) throws ApiException {
        Call localVarCall = this.revertBranchValidateBeforeCall(repository, branch, revertCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call revertBranchAsync(String repository, String branch, RevertCreation revertCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revertBranchValidateBeforeCall(repository, branch, revertCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIrevertBranchRequest revertBranch(String repository, String branch, RevertCreation revertCreation) {
        return new APIrevertBranchRequest(repository, branch, revertCreation);
    }

    public class APIrevertBranchRequest {
        private final String repository;
        private final String branch;
        private final RevertCreation revertCreation;

        private APIrevertBranchRequest(String repository, String branch, RevertCreation revertCreation) {
            this.repository = repository;
            this.branch = branch;
            this.revertCreation = revertCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.revertBranchCall(this.repository, this.branch, this.revertCreation, _callback);
        }

        public void execute() throws ApiException {
            BranchesApi.this.revertBranchWithHttpInfo(this.repository, this.branch, this.revertCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.revertBranchWithHttpInfo(this.repository, this.branch, this.revertCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return BranchesApi.this.revertBranchAsync(this.repository, this.branch, this.revertCreation, _callback);
        }
    }

    public class APIresetBranchRequest {
        private final String repository;
        private final String branch;
        private final ResetCreation resetCreation;

        private APIresetBranchRequest(String repository, String branch, ResetCreation resetCreation) {
            this.repository = repository;
            this.branch = branch;
            this.resetCreation = resetCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.resetBranchCall(this.repository, this.branch, this.resetCreation, _callback);
        }

        public void execute() throws ApiException {
            BranchesApi.this.resetBranchWithHttpInfo(this.repository, this.branch, this.resetCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.resetBranchWithHttpInfo(this.repository, this.branch, this.resetCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return BranchesApi.this.resetBranchAsync(this.repository, this.branch, this.resetCreation, _callback);
        }
    }

    public class APIlistBranchesRequest {
        private final String repository;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistBranchesRequest(String repository) {
            this.repository = repository;
        }

        public APIlistBranchesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistBranchesRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistBranchesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.listBranchesCall(this.repository, this.prefix, this.after, this.amount, _callback);
        }

        public RefList execute() throws ApiException {
            ApiResponse localVarResp = BranchesApi.this.listBranchesWithHttpInfo(this.repository, this.prefix, this.after, this.amount);
            return (RefList)localVarResp.getData();
        }

        public ApiResponse<RefList> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.listBranchesWithHttpInfo(this.repository, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<RefList> _callback) throws ApiException {
            return BranchesApi.this.listBranchesAsync(this.repository, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIgetBranchRequest {
        private final String repository;
        private final String branch;

        private APIgetBranchRequest(String repository, String branch) {
            this.repository = repository;
            this.branch = branch;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.getBranchCall(this.repository, this.branch, _callback);
        }

        public Ref execute() throws ApiException {
            ApiResponse localVarResp = BranchesApi.this.getBranchWithHttpInfo(this.repository, this.branch);
            return (Ref)localVarResp.getData();
        }

        public ApiResponse<Ref> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.getBranchWithHttpInfo(this.repository, this.branch);
        }

        public Call executeAsync(ApiCallback<Ref> _callback) throws ApiException {
            return BranchesApi.this.getBranchAsync(this.repository, this.branch, _callback);
        }
    }

    public class APIdiffBranchRequest {
        private final String repository;
        private final String branch;
        private String after;
        private Integer amount;
        private String prefix;
        private String delimiter;

        private APIdiffBranchRequest(String repository, String branch) {
            this.repository = repository;
            this.branch = branch;
        }

        public APIdiffBranchRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIdiffBranchRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIdiffBranchRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIdiffBranchRequest delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.diffBranchCall(this.repository, this.branch, this.after, this.amount, this.prefix, this.delimiter, _callback);
        }

        public DiffList execute() throws ApiException {
            ApiResponse localVarResp = BranchesApi.this.diffBranchWithHttpInfo(this.repository, this.branch, this.after, this.amount, this.prefix, this.delimiter);
            return (DiffList)localVarResp.getData();
        }

        public ApiResponse<DiffList> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.diffBranchWithHttpInfo(this.repository, this.branch, this.after, this.amount, this.prefix, this.delimiter);
        }

        public Call executeAsync(ApiCallback<DiffList> _callback) throws ApiException {
            return BranchesApi.this.diffBranchAsync(this.repository, this.branch, this.after, this.amount, this.prefix, this.delimiter, _callback);
        }
    }

    public class APIdeleteBranchRequest {
        private final String repository;
        private final String branch;

        private APIdeleteBranchRequest(String repository, String branch) {
            this.repository = repository;
            this.branch = branch;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.deleteBranchCall(this.repository, this.branch, _callback);
        }

        public void execute() throws ApiException {
            BranchesApi.this.deleteBranchWithHttpInfo(this.repository, this.branch);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.deleteBranchWithHttpInfo(this.repository, this.branch);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return BranchesApi.this.deleteBranchAsync(this.repository, this.branch, _callback);
        }
    }

    public class APIcreateBranchRequest {
        private final String repository;
        private final BranchCreation branchCreation;

        private APIcreateBranchRequest(String repository, BranchCreation branchCreation) {
            this.repository = repository;
            this.branchCreation = branchCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.createBranchCall(this.repository, this.branchCreation, _callback);
        }

        public String execute() throws ApiException {
            ApiResponse localVarResp = BranchesApi.this.createBranchWithHttpInfo(this.repository, this.branchCreation);
            return (String)localVarResp.getData();
        }

        public ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.createBranchWithHttpInfo(this.repository, this.branchCreation);
        }

        public Call executeAsync(ApiCallback<String> _callback) throws ApiException {
            return BranchesApi.this.createBranchAsync(this.repository, this.branchCreation, _callback);
        }
    }

    public class APIcherryPickRequest {
        private final String repository;
        private final String branch;
        private final CherryPickCreation cherryPickCreation;

        private APIcherryPickRequest(String repository, String branch, CherryPickCreation cherryPickCreation) {
            this.repository = repository;
            this.branch = branch;
            this.cherryPickCreation = cherryPickCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BranchesApi.this.cherryPickCall(this.repository, this.branch, this.cherryPickCreation, _callback);
        }

        public Commit execute() throws ApiException {
            ApiResponse localVarResp = BranchesApi.this.cherryPickWithHttpInfo(this.repository, this.branch, this.cherryPickCreation);
            return (Commit)localVarResp.getData();
        }

        public ApiResponse<Commit> executeWithHttpInfo() throws ApiException {
            return BranchesApi.this.cherryPickWithHttpInfo(this.repository, this.branch, this.cherryPickCreation);
        }

        public Call executeAsync(ApiCallback<Commit> _callback) throws ApiException {
            return BranchesApi.this.cherryPickAsync(this.repository, this.branch, this.cherryPickCreation, _callback);
        }
    }
}

