/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.Commit;
import io.lakefs.clients.sdk.model.CommitCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CommitsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CommitsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CommitsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call commitCall(String repository, String branch, CommitCreation commitCreation, String sourceMetarange, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CommitCreation localVarPostBody = commitCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/commits".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sourceMetarange != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source_metarange", sourceMetarange));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call commitValidateBeforeCall(String repository, String branch, CommitCreation commitCreation, String sourceMetarange, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling commit(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling commit(Async)");
        }
        if (commitCreation == null) {
            throw new ApiException("Missing the required parameter 'commitCreation' when calling commit(Async)");
        }
        return this.commitCall(repository, branch, commitCreation, sourceMetarange, _callback);
    }

    private ApiResponse<Commit> commitWithHttpInfo(String repository, String branch, CommitCreation commitCreation, String sourceMetarange) throws ApiException {
        Call localVarCall = this.commitValidateBeforeCall(repository, branch, commitCreation, sourceMetarange, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call commitAsync(String repository, String branch, CommitCreation commitCreation, String sourceMetarange, ApiCallback<Commit> _callback) throws ApiException {
        Call localVarCall = this.commitValidateBeforeCall(repository, branch, commitCreation, sourceMetarange, _callback);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcommitRequest commit(String repository, String branch, CommitCreation commitCreation) {
        return new APIcommitRequest(repository, branch, commitCreation);
    }

    private Call getCommitCall(String repository, String commitId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/commits/{commitId}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{commitId}", this.localVarApiClient.escapeString(commitId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommitValidateBeforeCall(String repository, String commitId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getCommit(Async)");
        }
        if (commitId == null) {
            throw new ApiException("Missing the required parameter 'commitId' when calling getCommit(Async)");
        }
        return this.getCommitCall(repository, commitId, _callback);
    }

    private ApiResponse<Commit> getCommitWithHttpInfo(String repository, String commitId) throws ApiException {
        Call localVarCall = this.getCommitValidateBeforeCall(repository, commitId, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCommitAsync(String repository, String commitId, ApiCallback<Commit> _callback) throws ApiException {
        Call localVarCall = this.getCommitValidateBeforeCall(repository, commitId, _callback);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetCommitRequest getCommit(String repository, String commitId) {
        return new APIgetCommitRequest(repository, commitId);
    }

    public class APIgetCommitRequest {
        private final String repository;
        private final String commitId;

        private APIgetCommitRequest(String repository, String commitId) {
            this.repository = repository;
            this.commitId = commitId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CommitsApi.this.getCommitCall(this.repository, this.commitId, _callback);
        }

        public Commit execute() throws ApiException {
            ApiResponse localVarResp = CommitsApi.this.getCommitWithHttpInfo(this.repository, this.commitId);
            return (Commit)localVarResp.getData();
        }

        public ApiResponse<Commit> executeWithHttpInfo() throws ApiException {
            return CommitsApi.this.getCommitWithHttpInfo(this.repository, this.commitId);
        }

        public Call executeAsync(ApiCallback<Commit> _callback) throws ApiException {
            return CommitsApi.this.getCommitAsync(this.repository, this.commitId, _callback);
        }
    }

    public class APIcommitRequest {
        private final String repository;
        private final String branch;
        private final CommitCreation commitCreation;
        private String sourceMetarange;

        private APIcommitRequest(String repository, String branch, CommitCreation commitCreation) {
            this.repository = repository;
            this.branch = branch;
            this.commitCreation = commitCreation;
        }

        public APIcommitRequest sourceMetarange(String sourceMetarange) {
            this.sourceMetarange = sourceMetarange;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CommitsApi.this.commitCall(this.repository, this.branch, this.commitCreation, this.sourceMetarange, _callback);
        }

        public Commit execute() throws ApiException {
            ApiResponse localVarResp = CommitsApi.this.commitWithHttpInfo(this.repository, this.branch, this.commitCreation, this.sourceMetarange);
            return (Commit)localVarResp.getData();
        }

        public ApiResponse<Commit> executeWithHttpInfo() throws ApiException {
            return CommitsApi.this.commitWithHttpInfo(this.repository, this.branch, this.commitCreation, this.sourceMetarange);
        }

        public Call executeAsync(ApiCallback<Commit> _callback) throws ApiException {
            return CommitsApi.this.commitAsync(this.repository, this.branch, this.commitCreation, this.sourceMetarange, _callback);
        }
    }
}

