/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.StorageURI;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MetadataApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MetadataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getMetaRangeCall(String repository, String metaRange, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/metadata/meta_range/{meta_range}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{meta_range}", this.localVarApiClient.escapeString(metaRange.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetaRangeValidateBeforeCall(String repository, String metaRange, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getMetaRange(Async)");
        }
        if (metaRange == null) {
            throw new ApiException("Missing the required parameter 'metaRange' when calling getMetaRange(Async)");
        }
        return this.getMetaRangeCall(repository, metaRange, _callback);
    }

    private ApiResponse<StorageURI> getMetaRangeWithHttpInfo(String repository, String metaRange) throws ApiException {
        Call localVarCall = this.getMetaRangeValidateBeforeCall(repository, metaRange, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMetaRangeAsync(String repository, String metaRange, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.getMetaRangeValidateBeforeCall(repository, metaRange, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMetaRangeRequest getMetaRange(String repository, String metaRange) {
        return new APIgetMetaRangeRequest(repository, metaRange);
    }

    private Call getRangeCall(String repository, String range, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/metadata/range/{range}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{range}", this.localVarApiClient.escapeString(range.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRangeValidateBeforeCall(String repository, String range, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRange(Async)");
        }
        if (range == null) {
            throw new ApiException("Missing the required parameter 'range' when calling getRange(Async)");
        }
        return this.getRangeCall(repository, range, _callback);
    }

    private ApiResponse<StorageURI> getRangeWithHttpInfo(String repository, String range) throws ApiException {
        Call localVarCall = this.getRangeValidateBeforeCall(repository, range, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getRangeAsync(String repository, String range, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.getRangeValidateBeforeCall(repository, range, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRangeRequest getRange(String repository, String range) {
        return new APIgetRangeRequest(repository, range);
    }

    public class APIgetRangeRequest {
        private final String repository;
        private final String range;

        private APIgetRangeRequest(String repository, String range) {
            this.repository = repository;
            this.range = range;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MetadataApi.this.getRangeCall(this.repository, this.range, _callback);
        }

        public StorageURI execute() throws ApiException {
            ApiResponse localVarResp = MetadataApi.this.getRangeWithHttpInfo(this.repository, this.range);
            return (StorageURI)localVarResp.getData();
        }

        public ApiResponse<StorageURI> executeWithHttpInfo() throws ApiException {
            return MetadataApi.this.getRangeWithHttpInfo(this.repository, this.range);
        }

        public Call executeAsync(ApiCallback<StorageURI> _callback) throws ApiException {
            return MetadataApi.this.getRangeAsync(this.repository, this.range, _callback);
        }
    }

    public class APIgetMetaRangeRequest {
        private final String repository;
        private final String metaRange;

        private APIgetMetaRangeRequest(String repository, String metaRange) {
            this.repository = repository;
            this.metaRange = metaRange;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MetadataApi.this.getMetaRangeCall(this.repository, this.metaRange, _callback);
        }

        public StorageURI execute() throws ApiException {
            ApiResponse localVarResp = MetadataApi.this.getMetaRangeWithHttpInfo(this.repository, this.metaRange);
            return (StorageURI)localVarResp.getData();
        }

        public ApiResponse<StorageURI> executeWithHttpInfo() throws ApiException {
            return MetadataApi.this.getMetaRangeWithHttpInfo(this.repository, this.metaRange);
        }

        public Call executeAsync(ApiCallback<StorageURI> _callback) throws ApiException {
            return MetadataApi.this.getMetaRangeAsync(this.repository, this.metaRange, _callback);
        }
    }
}

