/*
 * Decompiled with CFR 0.152.
 */
package fs2.aws.kinesis;

import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.std.Dispatcher;
import cats.effect.std.Dispatcher$;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.QueueSource;
import cats.implicits$;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.aws.core.package$;
import fs2.aws.kinesis.ChunkedRecordProcessor;
import fs2.aws.kinesis.CommittableRecord;
import fs2.aws.kinesis.CommittableRecord$;
import fs2.aws.kinesis.Kinesis$;
import fs2.aws.kinesis.KinesisCheckpointSettings;
import fs2.aws.kinesis.KinesisConsumerSettings;
import fs2.aws.kinesis.KinesisConsumerSettings$;
import fs2.compat.NotGiven$;
import fs2.concurrent.Signal;
import fs2.concurrent.SignallingRef;
import fs2.concurrent.SignallingRef$;
import java.io.Serializable;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dhaB\t\u0013!\u0003\r\t!\u0007\u0005\u0006C\u0001!\tA\t\u0005\u0006M\u0001!\ta\n\u0005\u0006M\u0001!\t!\u0014\u0005\u0006'\u00021\t\u0001\u0016\u0005\u00065\u00021\taW\u0004\u0006kJA\tA\u001e\u0004\u0006#IA\ta\u001e\u0005\u0006q\u001e!\t!\u001f\u0004\u0006u\u001e\t\ta\u001f\u0005\u000b\u0003\u000fI!1!Q\u0001\f\u0005%\u0001BCA\u0013\u0013\t\r\t\u0015a\u0003\u0002(!1\u00010\u0003C\u0001\u0003[A\u0001\"!\u000f\n\t\u0003\u0011\u00121\b\u0005\u00075&!\t!a\u001a\t\u000f\u00055t\u0001\"\u0001\u0002p!9\u0011QN\u0004\u0005\u0002\u0005M%aB&j]\u0016\u001c\u0018n\u001d\u0006\u0003'Q\tqa[5oKNL7O\u0003\u0002\u0016-\u0005\u0019\u0011m^:\u000b\u0003]\t1AZ:3\u0007\u0001)\"A\u0007\u0018\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002GA\u0011A\u0004J\u0005\u0003Ku\u0011A!\u00168ji\u0006)\"/Z1e\rJ|WnS5oKNL7o\u0015;sK\u0006lGc\u0001\u0015?\u0017B!\u0011F\u000b\u0017;\u001b\u00051\u0012BA\u0016\u0017\u0005\u0019\u0019FO]3b[B\u0011QF\f\u0007\u0001\t\u0015y\u0003A1\u00011\u0005\u00051UCA\u00199#\t\u0011T\u0007\u0005\u0002\u001dg%\u0011A'\b\u0002\b\u001d>$\b.\u001b8h!\tab'\u0003\u00028;\t\u0019\u0011I\\=\u0005\u000ber#\u0019A\u0019\u0003\t}#C%\r\t\u0003wqj\u0011AE\u0005\u0003{I\u0011\u0011cQ8n[&$H/\u00192mKJ+7m\u001c:e\u0011\u0015y$\u00011\u0001A\u0003\u001d\t\u0007\u000f\u001d(b[\u0016\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\"\u001e\u001b\u0005!%BA#\u0019\u0003\u0019a$o\\8u}%\u0011q)H\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H;!)AJ\u0001a\u0001\u0001\u0006Q1\u000f\u001e:fC6t\u0015-\\3\u0015\u0005!r\u0005\"B(\u0004\u0001\u0004\u0001\u0016AD2p]N,X.\u001a:D_:4\u0017n\u001a\t\u0003wEK!A\u0015\n\u0003/-Kg.Z:jg\u000e{gn];nKJ\u001cV\r\u001e;j]\u001e\u001c\u0018\u0001\b:fC\u0012\u001c\u0005.\u001e8lK\u00124%o\\7LS:,7/[:TiJ,\u0017-\u001c\u000b\u0003+f\u0003B!\u000b\u0016--B\u0019\u0011f\u0016\u001e\n\u0005a3\"!B\"ik:\\\u0007\"B(\u0005\u0001\u0004\u0001\u0016!E2iK\u000e\\\u0007o\\5oiJ+7m\u001c:egR\u0011A\f\u001d\t\u0006;\nd#(\u001a\b\u0003=\u0002t!aQ0\n\u0003]I!!\u0019\f\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0005!&\u0004XM\u0003\u0002b-A\u0011aM\\\u0007\u0002O*\u0011\u0001.[\u0001\ne\u0016$(/[3wC2T!a\u00056\u000b\u0005-d\u0017AB1nCj|gNC\u0001n\u0003!\u0019xN\u001a;xCJ,\u0017BA8h\u0005MY\u0015N\\3tSN\u001cE.[3oiJ+7m\u001c:e\u0011\u0015\tX\u00011\u0001s\u0003I\u0019\u0007.Z2la>Lg\u000e^*fiRLgnZ:\u0011\u0005m\u001a\u0018B\u0001;\u0013\u0005eY\u0015N\\3tSN\u001c\u0005.Z2la>Lg\u000e^*fiRLgnZ:\u0002\u000f-Kg.Z:jgB\u00111hB\n\u0003\u000fm\ta\u0001P5oSRtD#\u0001<\u0003\u001d\u001d+g.\u001a:jG.Kg.Z:jgV\u0011Ap`\n\u0004\u0013mi\bcA\u001e\u0001}B\u0011Qf \u0003\u0007_%\u0011\r!!\u0001\u0016\u0007E\n\u0019\u0001\u0002\u0004\u0002\u0006}\u0014\r!\r\u0002\u0005?\u0012\"#'\u0001\u0006fm&$WM\\2fIE\u0002R!a\u0003\u0002 ytA!!\u0004\u0002\u001c9!\u0011qBA\u000b\u001d\r\u0019\u0015\u0011C\u0005\u0003\u0003'\tAaY1ug&!\u0011qCA\r\u0003\u0019)gMZ3di*\u0011\u00111C\u0005\u0004C\u0006u!\u0002BA\f\u00033IA!!\t\u0002$\t)\u0011i]=oG*\u0019\u0011-!\b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0003\u0002\f\u0005%b0\u0003\u0003\u0002,\u0005\r\"AC\"p]\u000e,(O]3oiR\u0011\u0011q\u0006\u000b\u0007\u0003c\t)$a\u000e\u0011\t\u0005M\u0012B`\u0007\u0002\u000f!9\u0011q\u0001\u0007A\u0004\u0005%\u0001bBA\u0013\u0019\u0001\u000f\u0011qE\u0001\u001ce\u0016\fGm\u00115v].\u001chI]8n\u0017&tWm]5t'R\u0014X-Y7\u0015\r\u0005u\u0012qHA\"!\u0011I#F ,\t\r\u0005\u0005S\u00021\u0001Q\u00031\u0019HO]3b[\u000e{gNZ5h\u0011\u001d\t)%\u0004a\u0001\u0003\u000f\n\u0001c]2iK\u0012,H.\u001a:GC\u000e$xN]=\u0011\u000fq\tI%!\u0014\u0002Z%\u0019\u00111J\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0013.A\u0005qe>\u001cWm]:pe&!\u0011qKA)\u0005m\u0019\u0006.\u0019:e%\u0016\u001cwN\u001d3Qe>\u001cWm]:pe\u001a\u000b7\r^8ssB!Qf`A.!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1S\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\t)'a\u0018\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014H\u0003BA5\u0003W\u0002R!\u00182\u007fu\u0015DQ!\u001d\bA\u0002I\faa\u0019:fCR,W\u0003BA9\u0003s\"B!a\u001d\u0002\u000eR1\u0011QOAA\u0003\u000f\u0003Ba\u000f\u0001\u0002xA\u0019Q&!\u001f\u0005\r=z!\u0019AA>+\r\t\u0014Q\u0010\u0003\b\u0003\u007f\nIH1\u00012\u0005\u0011yF\u0005J\u001a\t\u0013\u0005\ru\"!AA\u0004\u0005\u0015\u0015AC3wS\u0012,gnY3%gA1\u00111BA\u0010\u0003oB\u0011\"!#\u0010\u0003\u0003\u0005\u001d!a#\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0004\u0002\f\u0005%\u0012q\u000f\u0005\b\u0003\u000bz\u0001\u0019AAH!\u001da\u0012\u0011JA'\u0003#\u0003R!LA=\u00037*B!!&\u0002\u001eRA\u0011qSAY\u0003\u000f\f9\u000e\u0006\u0004\u0002\u001a\u0006\u0015\u00161\u0016\t\u0005w\u0001\tY\nE\u0002.\u0003;#aa\f\tC\u0002\u0005}UcA\u0019\u0002\"\u00129\u00111UAO\u0005\u0004\t$\u0001B0%IQB\u0011\"a*\u0011\u0003\u0003\u0005\u001d!!+\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0004\u0002\f\u0005}\u00111\u0014\u0005\n\u0003[\u0003\u0012\u0011!a\u0002\u0003_\u000b!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\tY!!\u000b\u0002\u001c\"9\u00111\u0017\tA\u0002\u0005U\u0016AE6j]\u0016\u001c\u0018n]!ts:\u001c7\t\\5f]R\u0004B!a.\u0002D6\u0011\u0011\u0011\u0018\u0006\u0004'\u0005m&\u0002BA_\u0003\u007f\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0004\u0003\u0003T\u0017AB1xgN$7.\u0003\u0003\u0002F\u0006e&AE&j]\u0016\u001c\u0018n]!ts:\u001c7\t\\5f]RDq!!3\u0011\u0001\u0004\tY-A\nes:\fWn\u001c#c\u0003NLhnY\"mS\u0016tG\u000f\u0005\u0003\u0002N\u0006MWBAAh\u0015\u0011\t\t.a/\u0002\u0011\u0011Lh.Y7pI\nLA!!6\u0002P\n\u0019B)\u001f8b[>$%-Q:z]\u000e\u001cE.[3oi\"9\u0011\u0011\u001c\tA\u0002\u0005m\u0017!F2m_V$w+\u0019;dQ\u0006\u001b\u0018P\\2DY&,g\u000e\u001e\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A^\u0003)\u0019Gn\\;eo\u0006$8\r[\u0005\u0005\u0003K\fyNA\u000bDY>,HmV1uG\"\f5/\u001f8d\u00072LWM\u001c;")
public interface Kinesis<F> {
    public static <F> Kinesis<F> create(KinesisAsyncClient kinesisAsyncClient, DynamoDbAsyncClient dynamoDbAsyncClient, CloudWatchAsyncClient cloudWatchAsyncClient, Async<F> evidence$5, GenConcurrent<F, Throwable> evidence$6) {
        return Kinesis$.MODULE$.create(kinesisAsyncClient, dynamoDbAsyncClient, cloudWatchAsyncClient, evidence$5, evidence$6);
    }

    public static <F> Kinesis<F> create(Function1<ShardRecordProcessorFactory, F> schedulerFactory, Async<F> evidence$3, GenConcurrent<F, Throwable> evidence$4) {
        return Kinesis$.MODULE$.create(schedulerFactory, evidence$3, evidence$4);
    }

    default public Stream<F, CommittableRecord> readFromKinesisStream(String appName, String streamName) {
        return this.readFromKinesisStream(KinesisConsumerSettings$.MODULE$.apply(streamName, appName, KinesisConsumerSettings$.MODULE$.apply$default$3(), KinesisConsumerSettings$.MODULE$.apply$default$4(), KinesisConsumerSettings$.MODULE$.apply$default$5(), KinesisConsumerSettings$.MODULE$.apply$default$6()));
    }

    default public Stream<F, CommittableRecord> readFromKinesisStream(KinesisConsumerSettings consumerConfig) {
        return this.readChunkedFromKinesisStream(consumerConfig).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.default());
    }

    public Stream<F, Chunk<CommittableRecord>> readChunkedFromKinesisStream(KinesisConsumerSettings var1);

    public Function1<Stream<F, CommittableRecord>, Stream<F, KinesisClientRecord>> checkpointRecords(KinesisCheckpointSettings var1);

    public static void $init$(Kinesis $this) {
    }

    public static abstract class GenericKinesis<F>
    implements Kinesis<F> {
        private final Async<F> evidence$1;

        @Override
        public Stream<F, CommittableRecord> readFromKinesisStream(String appName, String streamName) {
            return ((Kinesis)this).readFromKinesisStream(appName, streamName);
        }

        @Override
        public Stream<F, CommittableRecord> readFromKinesisStream(KinesisConsumerSettings consumerConfig) {
            return ((Kinesis)this).readFromKinesisStream(consumerConfig);
        }

        public Stream<F, Chunk<CommittableRecord>> readChunksFromKinesisStream(KinesisConsumerSettings streamConfig, Function1<ShardRecordProcessorFactory, F> schedulerFactory) {
            return Stream$.MODULE$.resource(Dispatcher$.MODULE$.parallel(this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)dispatcher -> Stream$.MODULE$.eval(Queue$.MODULE$.bounded(BoxesRunTime.unboxToInt((Object)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)streamConfig.bufferSize()), RefType$.MODULE$.refinedRefType())), $this.evidence$1)).flatMap((Function1 & Serializable)buffer -> Stream$.MODULE$.eval(SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), $this.evidence$1)).flatMap((Function1 & Serializable)interruptSignal -> this.instantiateScheduler$1((Dispatcher)dispatcher, (Queue)buffer, (SignallingRef)interruptSignal, schedulerFactory).flatMap((Function1 & Serializable)x$2 -> {
                Scheduler scheduler = x$2;
                return Stream$.MODULE$.fromQueueUnterminated((QueueSource)buffer, Stream$.MODULE$.fromQueueUnterminated$default$2(), $this.evidence$1).interruptWhen((Signal)interruptSignal, $this.evidence$1);
            }, NotGiven$.MODULE$.default()), NotGiven$.MODULE$.default()), NotGiven$.MODULE$.default()), NotGiven$.MODULE$.default());
        }

        @Override
        public Function1<Stream<F, CommittableRecord>, Stream<F, KinesisClientRecord>> checkpointRecords(KinesisCheckpointSettings checkpointSettings) {
            return (Function1 & Serializable)x$5 -> Stream.NestedStreamOps$.MODULE$.parJoinUnbounded$extension(Stream$.MODULE$.NestedStreamOps(x$5.through(package$.MODULE$.groupBy((Function1 & Serializable)r -> cats.effect.package$.MODULE$.Sync().apply($this.evidence$1).pure((Object)r.shardId()), $this.evidence$1)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Stream st = (Stream)tuple2._2();
                    return st.broadcastThrough((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{this.checkpoint$1(checkpointSettings), GenericKinesis.bypass$1()}), $this.evidence$1);
                }
                throw new MatchError((Object)tuple2);
            })), $this.evidence$1);
        }

        private final Stream instantiateScheduler$1(Dispatcher dispatcher, Queue queue, SignallingRef signal, Function1 schedulerFactory$1) {
            return Stream$.MODULE$.bracket(implicits$.MODULE$.toFlatMapOps(schedulerFactory$1.apply(() -> new ChunkedRecordProcessor((Function1<Chunk<CommittableRecord>, BoxedUnit>)(Function1 & Serializable)records -> {
                dispatcher.unsafeRunSync(queue.offer((Object)records));
                return BoxedUnit.UNIT;
            })), this.evidence$1).flatTap((Function1 & Serializable)s -> cats.effect.package$.MODULE$.Concurrent().apply($this.evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).start(implicits$.MODULE$.toFlatMapOps(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> s.run()), $this.evidence$1).flatTap((Function1 & Serializable)x$1 -> signal.set((Object)BoxesRunTime.boxToBoolean((boolean)true))))), (Function1 & Serializable)s -> cats.effect.package$.MODULE$.Async().apply($this.evidence$1).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> s.shutdown()));
        }

        private final Function1 checkpoint$1(KinesisCheckpointSettings checkpointSettings) {
            return (Function1 & Serializable)x$3 -> x$3.groupWithin(checkpointSettings.maxBatchSize(), checkpointSettings.maxBatchWait(), $this.evidence$1).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Chunk<CommittableRecord>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.size() > 0) {
                        return (B1)A1.toList().max(CommittableRecord$.MODULE$.orderBySequenceNumber());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Chunk<CommittableRecord> x1) {
                    Chunk<CommittableRecord> chunk = x1;
                    return chunk.size() > 0;
                }
            }).flatMap((Function1 & Serializable)cr -> Stream$.MODULE$.eval(implicits$.MODULE$.toFunctorOps(cr.checkpoint($this.evidence$1), $this.evidence$1).as((Object)cr.record())).drain(), NotGiven$.MODULE$.default());
        }

        private static final Function1 bypass$1() {
            return (Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)r -> r.record());
        }

        public GenericKinesis(Async<F> evidence$1, GenConcurrent<F, Throwable> evidence$2) {
            this.evidence$1 = evidence$1;
            Kinesis.$init$(this);
        }
    }
}

