/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.spqr.spring.autoconfigure.DataLoaderRegistryFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.DefaultGlobalContext;
import io.leangen.graphql.spqr.spring.autoconfigure.MvcContextFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import io.leangen.graphql.spqr.spring.web.GraphQLController;
import io.leangen.graphql.spqr.spring.web.GuiController;
import io.leangen.graphql.spqr.spring.web.mvc.DefaultGraphQLController;
import io.leangen.graphql.spqr.spring.web.mvc.DefaultGraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.mvc.GraphQLMvcExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MvcAutoConfiguration {
    @Autowired(required=false)
    private DataLoaderRegistryFactory dataLoaderRegistryFactory;

    @Bean
    @ConditionalOnMissingBean
    public MvcContextFactory globalContextFactory() {
        return params -> new DefaultGlobalContext(params.getNativeRequest());
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public GraphQLMvcExecutor defaultExecutor(MvcContextFactory contextFactory, SpqrProperties config) {
        DefaultGraphQLExecutor defaultExecutor = new DefaultGraphQLExecutor(contextFactory, this.dataLoaderRegistryFactory);
        return config.getHttp().getMvc().getExecutor() == SpqrProperties.Http.Mvc.Executor.BLOCKING ? defaultExecutor.blocking() : defaultExecutor;
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={GraphQLController.class})
    @ConditionalOnBean(value={GraphQLSchema.class})
    public DefaultGraphQLController graphQLController(GraphQL graphQL, GraphQLMvcExecutor executor) {
        return new DefaultGraphQLController(graphQL, executor);
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.spqr.gui.enabled"}, havingValue="true")
    public GuiController guiController(SpqrProperties config) {
        return new GuiController(config);
    }
}

