/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.spqr.spring.autoconfigure.DataLoaderRegistryFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.Internal;
import io.leangen.graphql.spqr.spring.autoconfigure.ReactiveContextFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import io.leangen.graphql.spqr.spring.modules.reactive.ReactorModule;
import io.leangen.graphql.spqr.spring.web.GraphQLController;
import io.leangen.graphql.spqr.spring.web.GuiController;
import io.leangen.graphql.spqr.spring.web.reactive.DefaultGraphQLController;
import io.leangen.graphql.spqr.spring.web.reactive.DefaultGraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.reactive.GraphQLReactiveExecutor;
import io.leangen.graphql.spqr.spring.web.reactive.WebFluxContext;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.ServerWebExchange;
import reactor.util.context.Context;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveAutoConfiguration {
    @Bean
    public Internal<Module> reactorModule() {
        return new Internal<Module>(new ReactorModule());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveContextFactory globalContextFactory() {
        return params -> new WebFluxContext((ServerWebExchange)params.getNativeRequest(), (Context)params.getEnvironment());
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public GraphQLReactiveExecutor graphQLExecutor(ReactiveContextFactory contextFactory, Optional<DataLoaderRegistryFactory> dataLoaderRegistryFactory) {
        return new DefaultGraphQLExecutor(contextFactory, (DataLoaderRegistryFactory)dataLoaderRegistryFactory.orElse(null));
    }

    @Bean
    @ConditionalOnProperty(name={"graphql.spqr.http.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={GraphQLController.class})
    @ConditionalOnBean(value={GraphQLSchema.class})
    public DefaultGraphQLController graphQLController(GraphQL graphQL, GraphQLReactiveExecutor executor) {
        return new DefaultGraphQLController(graphQL, executor);
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.spqr.gui.enabled"}, havingValue="true")
    public GuiController guiController(SpqrProperties config) {
        return new GuiController(config);
    }
}

