/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.spqr.spring.autoconfigure.DataLoaderRegistryFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.DefaultGlobalContext;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import io.leangen.graphql.spqr.spring.autoconfigure.WebSocketContextFactory;
import io.leangen.graphql.spqr.spring.web.apollo.PerConnectionApolloHandler;
import io.leangen.graphql.spqr.spring.web.mvc.websocket.DefaultGraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.mvc.websocket.GraphQLWebSocketExecutor;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={WebSocketConfigurer.class})
@ConditionalOnProperty(name={"graphql.spqr.ws.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={GraphQLSchema.class})
public class WebSocketAutoConfiguration
implements WebSocketConfigurer {
    private final GraphQL graphQL;
    private final SpqrProperties config;
    private final DataLoaderRegistryFactory dataLoaderRegistryFactory;

    @Autowired
    public WebSocketAutoConfiguration(GraphQL graphQL, SpqrProperties config, Optional<DataLoaderRegistryFactory> dataLoaderRegistryFactory) {
        this.graphQL = graphQL;
        this.config = config;
        this.dataLoaderRegistryFactory = dataLoaderRegistryFactory.orElse(null);
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
        String webSocketEndpoint = this.config.getWs().getEndpoint();
        String graphQLEndpoint = this.config.getHttp().getEndpoint();
        String endpointUrl = webSocketEndpoint == null ? graphQLEndpoint : webSocketEndpoint;
        webSocketHandlerRegistry.addHandler((WebSocketHandler)this.webSocketHandler(this.webSocketExecutor(this.webSocketContextFactory())), new String[]{endpointUrl}).setAllowedOrigins(this.config.getWs().getAllowedOrigins());
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketContextFactory webSocketContextFactory() {
        return params -> new DefaultGlobalContext(params.getNativeRequest());
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLWebSocketExecutor webSocketExecutor(WebSocketContextFactory contextFactory) {
        return new DefaultGraphQLExecutor(contextFactory, this.dataLoaderRegistryFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public PerConnectionApolloHandler webSocketHandler(GraphQLWebSocketExecutor executor) {
        boolean keepAliveEnabled = this.config.getWs().getKeepAlive().isEnabled();
        int keepAliveInterval = this.config.getWs().getKeepAlive().getIntervalMillis();
        int sendTimeLimit = this.config.getWs().getSendTimeLimit();
        int sendBufferSizeLimit = this.config.getWs().getSendBufferSizeLimit();
        return new PerConnectionApolloHandler(this.graphQL, executor, keepAliveEnabled ? this.defaultTaskScheduler() : null, keepAliveInterval, sendTimeLimit, sendBufferSizeLimit);
    }

    private TaskScheduler defaultTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolScheduler = new ThreadPoolTaskScheduler();
        threadPoolScheduler.setThreadNamePrefix("GraphQLWSKeepAlive-");
        threadPoolScheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        threadPoolScheduler.setRemoveOnCancelPolicy(true);
        threadPoolScheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        threadPoolScheduler.initialize();
        return threadPoolScheduler;
    }
}

