/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web.apollo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import io.leangen.graphql.spqr.spring.web.apollo.ApolloMessage;
import io.leangen.graphql.spqr.spring.web.apollo.ConnectionErrorMessage;
import io.leangen.graphql.spqr.spring.web.apollo.DataMessage;
import io.leangen.graphql.spqr.spring.web.apollo.ErrorMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.socket.TextMessage;

public class ApolloMessages {
    private static final ApolloMessage CONNECTION_ACK = new ApolloMessage("connection_ack");
    private static final ApolloMessage KEEP_ALIVE = new ApolloMessage("ka");
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static ApolloMessage from(TextMessage message) throws IOException {
        return (ApolloMessage)mapper.readValue((String)message.getPayload(), ApolloMessage.class);
    }

    public static TextMessage connectionAck() throws JsonProcessingException {
        return ApolloMessages.jsonMessage(CONNECTION_ACK);
    }

    public static TextMessage keepAlive() throws JsonProcessingException {
        return ApolloMessages.jsonMessage(KEEP_ALIVE);
    }

    public static TextMessage connectionError(String message) throws JsonProcessingException {
        return ApolloMessages.jsonMessage(new ConnectionErrorMessage(Collections.singletonMap("message", message)));
    }

    public static TextMessage connectionError() throws JsonProcessingException {
        return ApolloMessages.connectionError("Invalid message");
    }

    public static TextMessage data(String id, ExecutionResult result) throws JsonProcessingException {
        return ApolloMessages.jsonMessage(new DataMessage(id, result));
    }

    public static TextMessage complete(String id) throws JsonProcessingException {
        return ApolloMessages.jsonMessage(new ApolloMessage(id, "complete"));
    }

    public static TextMessage error(String id, List<GraphQLError> errors) throws JsonProcessingException {
        return ApolloMessages.jsonMessage(new ErrorMessage(id, errors.stream().filter(error -> !error.getErrorType().equals(ErrorType.DataFetchingException)).map(GraphQLError::toSpecification).collect(Collectors.toList())));
    }

    public static TextMessage error(String id, Throwable exception) throws JsonProcessingException {
        return ApolloMessages.error(id, exception.getMessage());
    }

    public static TextMessage error(String id, String message) throws JsonProcessingException {
        return ApolloMessages.jsonMessage(new ErrorMessage(id, Collections.singletonList(Collections.singletonMap("message", message))));
    }

    private static TextMessage jsonMessage(ApolloMessage message) throws JsonProcessingException {
        return new TextMessage((CharSequence)mapper.writeValueAsString((Object)message));
    }
}

