/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import graphql.GraphQL;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.ExecutableSchema;
import io.leangen.graphql.ExtendedGeneratorConfiguration;
import io.leangen.graphql.ExtensionProvider;
import io.leangen.graphql.GeneratorConfiguration;
import io.leangen.graphql.GraphQLRuntime;
import io.leangen.graphql.GraphQLSchemaGenerator;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.generator.mapping.ArgumentInjector;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.AbstractResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.AnnotatedResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.BeanResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.MethodInvokerFactory;
import io.leangen.graphql.metadata.strategy.query.PublicResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.spqr.spring.annotations.GraphQLApi;
import io.leangen.graphql.spqr.spring.annotations.WithResolverBuilder;
import io.leangen.graphql.spqr.spring.autoconfigure.AopAwareMethodInvokerFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.Internal;
import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import io.leangen.graphql.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.StandardMethodMetadata;

@AutoConfiguration
@ConditionalOnClass(value={GraphQLSchemaGenerator.class})
@EnableConfigurationProperties(value={SpqrProperties.class})
public class BaseAutoConfiguration {
    private final ConfigurableApplicationContext context;
    private final MethodInvokerFactory aopAwareFactory = new AopAwareMethodInvokerFactory();
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ResolverBuilder> globalResolverBuilderExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, TypeMapper> typeMapperExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, InputConverter> inputConverterExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, OutputConverter> outputConverterExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ArgumentInjector> argumentInjectorExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, SchemaTransformer> schemaTransformerExtensionProvider;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory> resolverInterceptorFactoryExtensionProvider;
    @Autowired(required=false)
    private ValueMapperFactory valueMapperFactory;
    @Autowired(required=false)
    private ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder> inputFieldBuilderProvider;
    @Autowired(required=false)
    private TypeInfoGenerator typeInfoGenerator;
    @Autowired(required=false)
    private AbstractInputHandler abstractInputHandler;
    @Autowired(required=false)
    private InclusionStrategy inclusionStrategy;
    @Autowired(required=false)
    private InterfaceMappingStrategy interfaceMappingStrategy;
    @Autowired(required=false)
    private Set<MessageBundle> messageBundles;
    @Autowired(required=false)
    private ExtensionProvider<GeneratorConfiguration, Module> moduleExtensionProvider;
    @Autowired(required=false)
    private List<Internal<Module>> internalModules;

    @Autowired
    public BaseAutoConfiguration(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @Bean
    @ConditionalOnMissingBean
    public AnnotatedResolverBuilder defaultAnnotatedResolverBuilder() {
        return (AnnotatedResolverBuilder)new AnnotatedResolverBuilder().withMethodInvokerFactory(this.aopAwareFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public BeanResolverBuilder defaultBeanResolverBuilder() {
        return (BeanResolverBuilder)new BeanResolverBuilder(new String[0]).withMethodInvokerFactory(this.aopAwareFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public PublicResolverBuilder defaultPublicResolverBuilder() {
        return (PublicResolverBuilder)new PublicResolverBuilder().withMethodInvokerFactory(this.aopAwareFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaGenerator graphQLSchemaGenerator(SpqrProperties spqrProperties) {
        GraphQLSchemaGenerator schemaGenerator = new GraphQLSchemaGenerator();
        schemaGenerator.withBasePackages(spqrProperties.getBasePackages());
        if (spqrProperties.getRelay().isEnabled()) {
            if (Utils.isNotEmpty((String)spqrProperties.getRelay().getMutationWrapper())) {
                schemaGenerator.withRelayCompliantMutations(spqrProperties.getRelay().getMutationWrapper(), spqrProperties.getRelay().getMutationWrapperDescription());
            } else {
                schemaGenerator.withRelayCompliantMutations();
            }
        }
        Map<String, SpqrBean> apiComponents = this.findGraphQLApiComponents();
        this.addOperationSources(schemaGenerator, apiComponents.values());
        if (this.internalModules != null) {
            this.internalModules.forEach(module -> schemaGenerator.withModules(new Module[]{(Module)module.get()}));
        }
        if (this.moduleExtensionProvider != null) {
            schemaGenerator.withModules(this.moduleExtensionProvider);
        }
        if (this.globalResolverBuilderExtensionProvider != null) {
            schemaGenerator.withResolverBuilders(this.globalResolverBuilderExtensionProvider);
        } else {
            schemaGenerator.withResolverBuilders(new ResolverBuilder[]{this.defaultAnnotatedResolverBuilder()});
        }
        if (this.typeMapperExtensionProvider != null) {
            schemaGenerator.withTypeMappers(this.typeMapperExtensionProvider);
        }
        if (this.inputConverterExtensionProvider != null) {
            schemaGenerator.withInputConverters(this.inputConverterExtensionProvider);
        }
        if (this.outputConverterExtensionProvider != null) {
            schemaGenerator.withOutputConverters(this.outputConverterExtensionProvider);
        }
        if (this.argumentInjectorExtensionProvider != null) {
            schemaGenerator.withArgumentInjectors(this.argumentInjectorExtensionProvider);
        }
        if (this.schemaTransformerExtensionProvider != null) {
            schemaGenerator.withSchemaTransformers(this.schemaTransformerExtensionProvider);
        }
        if (this.resolverInterceptorFactoryExtensionProvider != null) {
            schemaGenerator.withResolverInterceptorFactories(this.resolverInterceptorFactoryExtensionProvider);
        }
        if (this.valueMapperFactory != null) {
            schemaGenerator.withValueMapperFactory(this.valueMapperFactory);
        }
        if (this.inputFieldBuilderProvider != null) {
            schemaGenerator.withInputFieldBuilders(this.inputFieldBuilderProvider);
        }
        if (this.typeInfoGenerator != null) {
            schemaGenerator.withTypeInfoGenerator(this.typeInfoGenerator);
        }
        if (spqrProperties.isAbstractInputTypeResolution()) {
            schemaGenerator.withAbstractInputTypeResolution();
        }
        if (this.abstractInputHandler != null) {
            schemaGenerator.withAbstractInputHandler(this.abstractInputHandler);
        }
        if (this.messageBundles != null && !this.messageBundles.isEmpty()) {
            schemaGenerator.withStringInterpolation(this.messageBundles.toArray(new MessageBundle[0]));
        }
        if (this.inclusionStrategy != null) {
            schemaGenerator.withInclusionStrategy(this.inclusionStrategy);
        }
        if (this.interfaceMappingStrategy != null) {
            schemaGenerator.withInterfaceMappingStrategy(this.interfaceMappingStrategy);
        }
        if (spqrProperties.getRelay().isConnectionCheckRelaxed()) {
            schemaGenerator.withRelayConnectionCheckRelaxed();
        }
        return schemaGenerator;
    }

    private void addOperationSources(GraphQLSchemaGenerator schemaGenerator, Collection<SpqrBean> spqrBeans) {
        spqrBeans.forEach(spqrBean -> schemaGenerator.withOperationsFromBean(spqrBean.beanSupplier, spqrBean.type, spqrBean.exposedType, (ResolverBuilder[])spqrBean.resolverBuilders.stream().map(criteria -> this.findQualifiedBeanByType(criteria.getResolverType(), criteria.getValue(), criteria.getQualifierType())).peek(resolverBuilder -> {
            if (resolverBuilder instanceof AbstractResolverBuilder) {
                ((AbstractResolverBuilder)resolverBuilder).withMethodInvokerFactory(this.aopAwareFactory);
            }
        }).toArray(ResolverBuilder[]::new)));
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutableSchema graphQLExecutableSchema(GraphQLSchemaGenerator schemaGenerator) {
        return schemaGenerator.generateExecutable();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchema graphQLSchema(ExecutableSchema executableSchema) {
        return executableSchema.getSchema();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQL graphQL(ExecutableSchema schema, SpqrProperties spqrProperties, List<Instrumentation> instrumentations) {
        GraphQLRuntime.Builder builder = GraphQLRuntime.newGraphQL((ExecutableSchema)schema);
        instrumentations.forEach(arg_0 -> ((GraphQLRuntime.Builder)builder).instrumentation(arg_0));
        if (spqrProperties.getMaxComplexity() > 1) {
            builder.maximumQueryComplexity(spqrProperties.getMaxComplexity());
        }
        return builder.build();
    }

    private <T> T findQualifiedBeanByType(Class<? extends T> type, String qualifierValue, Class<? extends Annotation> qualifierType) {
        NoSuchBeanDefinitionException noSuchBeanDefinitionException = new NoSuchBeanDefinitionException(qualifierValue, "No matching " + type.getSimpleName() + " bean found for qualifier " + qualifierValue + " of type " + qualifierType.getSimpleName() + " !");
        try {
            if (Utils.isEmpty((String)qualifierValue)) {
                if (qualifierType.equals(Qualifier.class)) {
                    return (T)Optional.of(this.context.getBean(type)).orElseThrow(() -> noSuchBeanDefinitionException);
                }
                return (T)this.context.getBean(Arrays.stream(this.context.getBeanNamesForAnnotation(qualifierType)).filter(beanName -> type.isInstance(this.context.getBean(beanName))).findFirst().orElseThrow(() -> noSuchBeanDefinitionException), type);
            }
            return (T)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.context.getBeanFactory(), type, (String)qualifierValue);
        }
        catch (NoSuchBeanDefinitionException noBeanException) {
            ConfigurableListableBeanFactory factory = this.context.getBeanFactory();
            for (String name : factory.getBeanDefinitionNames()) {
                Map attributes;
                StandardMethodMetadata metadata;
                BeanDefinition bd = factory.getBeanDefinition(name);
                if (!(bd.getSource() instanceof StandardMethodMetadata) || !(metadata = (StandardMethodMetadata)bd.getSource()).getReturnTypeName().equals(type.getName()) || null == (attributes = metadata.getAnnotationAttributes(qualifierType.getName()))) continue;
                if (qualifierType.equals(Qualifier.class) && qualifierValue.equals(attributes.get("value"))) {
                    return (T)this.context.getBean(name, type);
                }
                return (T)this.context.getBean(name, type);
            }
            throw noSuchBeanDefinitionException;
        }
    }

    private Map<String, SpqrBean> findGraphQLApiComponents() {
        String[] apiBeanNames = this.context.getBeanNamesForAnnotation(GraphQLApi.class);
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        HashMap<String, SpqrBean> result = new HashMap<String, SpqrBean>();
        for (String beanName : apiBeanNames) {
            Set resolverBuilders;
            AnnotatedType beanType;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                StandardMethodMetadata metadata = (StandardMethodMetadata)beanDefinition.getSource();
                beanType = metadata.getIntrospectedMethod().getAnnotatedReturnType();
                resolverBuilders = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)metadata.getIntrospectedMethod(), WithResolverBuilder.class);
            } else {
                BeanDefinition current;
                BeanDefinition originatingBeanDefinition = current = beanDefinition;
                while (current != null) {
                    originatingBeanDefinition = current;
                    current = current.getOriginatingBeanDefinition();
                }
                ResolvableType resolvableType = originatingBeanDefinition.getResolvableType();
                beanType = resolvableType != ResolvableType.NONE && Utils.isNotEmpty((String)originatingBeanDefinition.getBeanClassName()) && !originatingBeanDefinition.getBeanClassName().startsWith("org.springframework.") ? GenericTypeReflector.annotate((Type)resolvableType.getType()) : GenericTypeReflector.annotate((Type)AopUtils.getTargetClass((Object)this.context.getBean(beanName)));
                resolverBuilders = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)beanType, WithResolverBuilder.class);
            }
            List<ResolverBuilderBeanCriteria> builders = resolverBuilders.stream().map(builder -> new ResolverBuilderBeanCriteria(builder.value(), builder.qualifierValue(), builder.qualifierType())).collect(Collectors.toList());
            result.put(beanName, new SpqrBean((ApplicationContext)this.context, beanName, beanType, builders));
        }
        return result;
    }

    private static class SpqrBean {
        final BeanScope scope;
        final Supplier<Object> beanSupplier;
        final AnnotatedType type;
        final Class<?> exposedType;
        final List<ResolverBuilderBeanCriteria> resolverBuilders;

        SpqrBean(ApplicationContext context, String beanName, AnnotatedType type, List<ResolverBuilderBeanCriteria> resolverBuilders) {
            BeanScope beanScope = BeanScope.findBeanScope(context, beanName);
            if (beanScope == BeanScope.SINGLETON) {
                Object bean = context.getBean(beanName);
                this.beanSupplier = () -> bean;
            } else {
                this.beanSupplier = () -> context.getBean(beanName);
            }
            this.scope = beanScope;
            this.type = type;
            this.exposedType = context.getType(beanName);
            this.resolverBuilders = Collections.unmodifiableList(resolverBuilders);
        }
    }

    private static class ResolverBuilderBeanCriteria {
        private final Class<? extends ResolverBuilder> resolverType;
        private final String value;
        private final Class<? extends Annotation> qualifierType;

        private ResolverBuilderBeanCriteria(Class<? extends ResolverBuilder> resolverType, String value, Class<? extends Annotation> qualifierType) {
            this.resolverType = resolverType;
            this.value = value;
            this.qualifierType = qualifierType;
        }

        String getValue() {
            return this.value;
        }

        Class<? extends Annotation> getQualifierType() {
            return this.qualifierType;
        }

        Class<? extends ResolverBuilder> getResolverType() {
            return this.resolverType;
        }
    }

    private static enum BeanScope {
        SINGLETON,
        PROTOTYPE,
        UNKNOWN;


        static BeanScope findBeanScope(ApplicationContext context, String beanName) {
            if (context.isSingleton(beanName)) {
                return SINGLETON;
            }
            if (context.isPrototype(beanName)) {
                return PROTOTYPE;
            }
            return UNKNOWN;
        }
    }
}

