/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web.apollo;

import graphql.GraphQL;
import io.leangen.graphql.spqr.spring.web.apollo.ApolloProtocolHandler;
import io.leangen.graphql.spqr.spring.web.mvc.websocket.GraphQLWebSocketExecutor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;

public class PerConnectionApolloHandler
implements WebSocketHandler,
SubProtocolCapable {
    private final GraphQL graphQL;
    private final GraphQLWebSocketExecutor executor;
    private final TaskScheduler taskScheduler;
    private final int keepAliveInterval;
    private final int sendTimeLimit;
    private final int sendBufferSizeLimit;
    private final Map<WebSocketSession, HandlerProxy> handlers;
    private static final List<String> GRAPHQL_WS = Collections.singletonList("graphql-ws");

    public PerConnectionApolloHandler(GraphQL graphQL, GraphQLWebSocketExecutor executor, TaskScheduler taskScheduler, int keepAliveInterval, int sendTimeLimit, int sendBufferSizeLimit) {
        this.graphQL = graphQL;
        this.executor = executor;
        this.taskScheduler = taskScheduler;
        this.keepAliveInterval = keepAliveInterval;
        this.sendTimeLimit = sendTimeLimit;
        this.sendBufferSizeLimit = sendBufferSizeLimit;
        this.handlers = new ConcurrentHashMap<WebSocketSession, HandlerProxy>();
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        ApolloProtocolHandler handler = new ApolloProtocolHandler(this.graphQL, this.executor, this.taskScheduler, this.keepAliveInterval);
        HandlerProxy proxy = new HandlerProxy(handler, this.decorateSession(session));
        this.handlers.put(session, proxy);
        proxy.afterConnectionEstablished();
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        this.getHandler(session).handleMessage(message);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        this.getHandler(session).handleTransportError(exception);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        try {
            this.getHandler(session).afterConnectionClosed(closeStatus);
        }
        finally {
            this.handlers.remove(session);
        }
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public List<String> getSubProtocols() {
        return GRAPHQL_WS;
    }

    @PreDestroy
    public void cancelAll() {
        this.handlers.forEach((session, handler) -> {
            try {
                session.close(CloseStatus.GOING_AWAY);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            handler.cancelAll();
        });
    }

    protected WebSocketSession decorateSession(WebSocketSession session) {
        return new ConcurrentWebSocketSessionDecorator(session, this.sendTimeLimit, this.sendBufferSizeLimit);
    }

    private HandlerProxy getHandler(WebSocketSession session) {
        HandlerProxy handler = this.handlers.get(session);
        if (handler == null) {
            throw new IllegalStateException("WebSocketHandler not found for " + session);
        }
        return handler;
    }

    private static class HandlerProxy {
        private final ApolloProtocolHandler handler;
        private final WebSocketSession session;

        HandlerProxy(ApolloProtocolHandler handler, WebSocketSession session) {
            this.handler = handler;
            this.session = session;
        }

        void afterConnectionEstablished() throws Exception {
            this.handler.afterConnectionEstablished(this.session);
        }

        void handleMessage(WebSocketMessage<?> message) throws Exception {
            this.handler.handleMessage(this.session, message);
        }

        void handleTransportError(Throwable exception) {
            this.handler.handleTransportError(this.session, exception);
        }

        void afterConnectionClosed(CloseStatus closeStatus) {
            this.handler.afterConnectionClosed(this.session, closeStatus);
        }

        void cancelAll() {
            this.handler.cancelAll();
        }
    }
}

