/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.modules.data;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.spqr.spring.modules.data.DefaultValueSchemaTransformer;
import io.leangen.graphql.spqr.spring.modules.data.Pagination;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.domain.AbstractPageRequest;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageableAdapter
extends AbstractTypeAdapter<Pageable, Pagination>
implements DefaultValueSchemaTransformer {
    private final DefaultPagination defaultPageable;
    private static final Set<Class<?>> SUPPORTED_CLASSES = new HashSet<Class>(Arrays.asList(Pageable.class, PageRequest.class, AbstractPageRequest.class, Pageable.unpaged().getClass()));

    public PageableAdapter(int defaultPageSize) {
        this.defaultPageable = new DefaultPagination(defaultPageSize);
    }

    public Pageable convertInput(Pagination substitute, AnnotatedType type, GlobalEnvironment environment, ValueMapper valueMapper) {
        return substitute.toPageable();
    }

    public Pagination convertOutput(Pageable original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return original.isPaged() ? new Pagination(original) : null;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultPageable;
    }

    public GraphQLInputObjectField transformInputField(GraphQLInputObjectField field, InputField inputField, OperationMapper operationMapper, BuildContext buildContext) {
        if (field.getName().equals("pageSize") && field.getInputFieldDefaultValue().getValue() == null && !(field.getType() instanceof GraphQLNonNull)) {
            return this.defaultPageable.isPaged() ? field.transform(builder -> builder.defaultValueProgrammatic((Object)this.defaultPageable.getPageSize())) : field.transform(builder -> builder.type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)field.getType())));
        }
        return field;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return SUPPORTED_CLASSES.contains(type.getType());
    }

    private static class DefaultPagination
    extends HashMap<String, Object> {
        DefaultPagination(int pageSize) {
            super(4);
            this.put("pageNumber", 0);
            this.put("pageSize", pageSize);
            this.put("sort", Collections.singletonMap("orders", Collections.emptyList()));
        }

        int getPageNumber() {
            return (Integer)this.get("pageNumber");
        }

        int getPageSize() {
            return (Integer)this.get("pageSize");
        }

        boolean isPaged() {
            return this.getPageSize() < Integer.MAX_VALUE;
        }
    }
}

