/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import io.leangen.graphql.spqr.spring.autoconfigure.ContextFactory;
import io.leangen.graphql.spqr.spring.autoconfigure.DataLoaderRegistryFactory;
import io.leangen.graphql.spqr.spring.web.GraphQLExecutor;
import io.leangen.graphql.spqr.spring.web.apollo.ApolloMessage;
import io.leangen.graphql.spqr.spring.web.apollo.DataMessage;
import io.leangen.graphql.spqr.spring.web.apollo.ErrorMessage;
import io.leangen.graphql.spqr.spring.web.dto.ExecutorParams;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class HttpExecutor<R>
implements GraphQLExecutor<R> {
    protected final ContextFactory<R> contextFactory;
    protected final DataLoaderRegistryFactory dataLoaderRegistryFactory;

    protected HttpExecutor(ContextFactory<R> contextFactory, DataLoaderRegistryFactory dataLoaderRegistryFactory) {
        this.contextFactory = contextFactory;
        this.dataLoaderRegistryFactory = dataLoaderRegistryFactory;
    }

    @Override
    public Object execute(GraphQL graphQL, ExecutorParams<R> params) {
        Mono promise = Mono.deferContextual(ctx -> Mono.fromFuture((CompletableFuture)graphQL.executeAsync(this.buildInput(params.graphQLRequest, params.request, ctx, this.contextFactory, this.dataLoaderRegistryFactory))));
        return params.transportType.isEventStream() ? this.stream(params.graphQLRequest.getId(), (Mono<ExecutionResult>)promise) : promise.map(ExecutionResult::toSpecification);
    }

    private Publisher<ApolloMessage> stream(String id, Mono<ExecutionResult> result) {
        return result.flatMapMany(r -> r.getData() instanceof Publisher ? (Publisher)r.getData() : Flux.just((Object)r)).map(next -> this.data(id, (ExecutionResult)next)).onErrorResume(error -> Mono.just((Object)this.error(id, (Throwable)error))).concatWith((Publisher)Mono.just((Object)new ApolloMessage(id, "complete")));
    }

    protected ApolloMessage data(String id, ExecutionResult result) {
        if (result.getErrors().isEmpty()) {
            return new DataMessage(id, result);
        }
        return new ErrorMessage(id, result.getErrors().stream().map(GraphQLError::toSpecification).collect(Collectors.toList()));
    }

    protected ApolloMessage error(String id, Throwable error) {
        return new ErrorMessage(id, Collections.singletonList(Collections.singletonMap("message", error.getMessage())));
    }
}

