/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import io.leangen.graphql.generator.mapping.DelegatingOutputConverter;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class DerivedTypeRegistry {
    private final Map<AnnotatedType, List<AnnotatedType>> derivedTypes = new IdentityHashMap<AnnotatedType, List<AnnotatedType>>();

    DerivedTypeRegistry(List<AnnotatedType> types, List<DelegatingOutputConverter> derivers) {
        types.forEach(type -> this.derive((AnnotatedType)type, derivers));
    }

    private void registerDerivatives(AnnotatedType type, List<AnnotatedType> derivedTypes, List<DelegatingOutputConverter> derivers) {
        derivedTypes.forEach(derived -> {
            this.derivedTypes.computeIfAbsent(type, k -> new ArrayList());
            this.derivedTypes.get(type).add((AnnotatedType)derived);
            this.derive((AnnotatedType)derived, derivers);
        });
    }

    private void derive(AnnotatedType type, List<DelegatingOutputConverter> derivers) {
        derivers.stream().filter(deriver -> deriver.supports(type)).findFirst().ifPresent(deriver -> this.registerDerivatives(type, deriver.getDerivedTypes(type), derivers));
    }

    List<AnnotatedType> getDerived(AnnotatedType type) {
        return this.derivedTypes.getOrDefault(type, Collections.emptyList());
    }
}

