/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.schema.DataFetchingEnvironment;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.DerivedTypeRegistry;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.InvocationContext;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.execution.ResolverInterceptor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.execution.ResolverInterceptorFactoryParams;
import io.leangen.graphql.generator.mapping.ConverterRegistry;
import io.leangen.graphql.generator.mapping.DelegatingOutputConverter;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.Utils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationExecutor {
    private final Operation operation;
    private final ValueMapper valueMapper;
    private final GlobalEnvironment globalEnvironment;
    private final ConverterRegistry converterRegistry;
    private final DerivedTypeRegistry derivedTypes;
    private final Map<Resolver, List<ResolverInterceptor>> interceptors;

    public OperationExecutor(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment, ResolverInterceptorFactory interceptorFactory) {
        this.operation = operation;
        this.valueMapper = valueMapper;
        this.globalEnvironment = globalEnvironment;
        this.converterRegistry = this.optimizeConverters(operation.getResolvers(), globalEnvironment.converters);
        this.derivedTypes = this.deriveTypes(operation.getResolvers(), this.converterRegistry);
        this.interceptors = operation.getResolvers().stream().collect(Collectors.toMap(Function.identity(), res -> interceptorFactory.getInterceptors(new ResolverInterceptorFactoryParams((Resolver)res))));
    }

    public Object execute(DataFetchingEnvironment env) throws Exception {
        ContextWrapper context;
        if (env.getContext() instanceof ContextWrapper) {
            context = (ContextWrapper)env.getContext();
            if (env.getArgument("clientMutationId") != null) {
                context.setClientMutationId((String)env.getArgument("clientMutationId"));
            }
        } else if (env.getContext() instanceof GraphQLContext) {
            context = (GraphQLContext)env.getContext();
            if (env.getArgument("clientMutationId") != null) {
                context.put("clientMutationId", env.getArgument("clientMutationId"));
            }
        }
        Map arguments = env.getArguments();
        Resolver resolver = this.operation.getApplicableResolver(arguments.keySet());
        if (resolver == null) {
            throw new GraphQLException("Resolver for operation " + this.operation.getName() + " accepting arguments: " + arguments.keySet() + " not implemented");
        }
        ResolutionEnvironment resolutionEnvironment = new ResolutionEnvironment(resolver, env, this.valueMapper, this.globalEnvironment, this.converterRegistry, this.derivedTypes);
        try {
            Object result = this.execute(resolver, resolutionEnvironment, arguments);
            return resolutionEnvironment.convertOutput(result, resolver.getReturnType());
        }
        catch (ReflectiveOperationException e) {
            OperationExecutor.sneakyThrow(this.unwrap(e));
            return null;
        }
    }

    private Object execute(Resolver resolver, ResolutionEnvironment resolutionEnvironment, Map<String, Object> rawArguments) throws Exception {
        int queryArgumentsCount = resolver.getArguments().size();
        Object[] args = new Object[queryArgumentsCount];
        for (int i = 0; i < queryArgumentsCount; ++i) {
            OperationArgument argDescriptor = resolver.getArguments().get(i);
            Object rawArgValue = rawArguments.get(argDescriptor.getName());
            args[i] = resolutionEnvironment.getInputValue(rawArgValue, argDescriptor);
        }
        InvocationContext invocationContext = new InvocationContext(this.operation, resolver, resolutionEnvironment, args);
        LinkedList<ResolverInterceptor> interceptors = new LinkedList<ResolverInterceptor>((Collection)this.interceptors.get(resolver));
        interceptors.add((ctx, cont) -> resolver.resolve(ctx.getResolutionEnvironment().context, ctx.getArguments()));
        return this.execute(invocationContext, interceptors);
    }

    private Object execute(InvocationContext context, Queue<ResolverInterceptor> interceptors) throws Exception {
        return interceptors.remove().aroundInvoke(context, ctx -> this.execute(ctx, interceptors));
    }

    private ConverterRegistry optimizeConverters(Collection<Resolver> resolvers, ConverterRegistry converters) {
        return converters.optimize(resolvers.stream().map(Resolver::getReturnType).collect(Collectors.toList()));
    }

    private DerivedTypeRegistry deriveTypes(Collection<Resolver> resolvers, ConverterRegistry converterRegistry) {
        return new DerivedTypeRegistry(resolvers.stream().map(Resolver::getReturnType).collect(Collectors.toList()), Utils.extractInstances(converterRegistry.getOutputConverters(), DelegatingOutputConverter.class).collect(Collectors.toList()));
    }

    private Throwable unwrap(ReflectiveOperationException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            return cause;
        }
        return e;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

