/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.GraphQLContext;
import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.generator.RelayDataFetchingEnvironmentDecorator;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.metadata.Directive;
import io.leangen.graphql.metadata.DirectiveArgument;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.MappingException;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilderParams;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.Directives;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMapper {
    private List<GraphQLFieldDefinition> queries;
    private List<GraphQLFieldDefinition> mutations;
    private List<GraphQLFieldDefinition> subscriptions;
    private List<GraphQLDirective> directives;
    private static final Logger log = LoggerFactory.getLogger(OperationMapper.class);

    public OperationMapper(String queryRoot, String mutationRoot, String subscriptionRoot, BuildContext buildContext) {
        this.queries = this.generateQueries(queryRoot, buildContext);
        this.mutations = this.generateMutations(mutationRoot, buildContext);
        this.subscriptions = this.generateSubscriptions(subscriptionRoot, buildContext);
        this.directives = this.generateDirectives(buildContext);
        buildContext.resolveTypeReferences();
    }

    private List<GraphQLFieldDefinition> generateQueries(String queryRoot, BuildContext buildContext) {
        Map<String, String> nodeQueriesByType;
        ArrayList<Operation> rootQueries = new ArrayList<Operation>(buildContext.operationRegistry.getRootQueries());
        List<GraphQLFieldDefinition> queries = rootQueries.stream().map(query -> this.toGraphQLField(queryRoot, (Operation)query, buildContext)).collect(Collectors.toList());
        buildContext.resolveTypeReferences();
        if (rootQueries.stream().noneMatch(query -> query.getName().equals("node")) && !(nodeQueriesByType = this.getNodeQueriesByType(rootQueries, queries, buildContext.typeRegistry, buildContext.node, buildContext)).isEmpty()) {
            queries.add(buildContext.relay.nodeField(buildContext.node, this.createNodeResolver(nodeQueriesByType, buildContext.relay)));
        }
        return queries;
    }

    private List<GraphQLFieldDefinition> generateMutations(String mutationRoot, BuildContext buildContext) {
        return buildContext.operationRegistry.getMutations().stream().map(mutation -> buildContext.relayMappingConfig.relayCompliantMutations ? this.toRelayMutation(mutationRoot, this.toGraphQLField((Operation)mutation, buildContext), this.createResolver((Operation)mutation, buildContext), buildContext) : this.toGraphQLField(mutationRoot, (Operation)mutation, buildContext)).collect(Collectors.toList());
    }

    private List<GraphQLFieldDefinition> generateSubscriptions(String subscriptionRoot, BuildContext buildContext) {
        return buildContext.operationRegistry.getSubscriptions().stream().map(subscription -> this.toGraphQLField(subscriptionRoot, (Operation)subscription, buildContext)).collect(Collectors.toList());
    }

    private List<GraphQLDirective> generateDirectives(BuildContext buildContext) {
        return buildContext.additionalDirectives.stream().map(directiveType -> buildContext.directiveBuilder.buildClientDirective((AnnotatedType)directiveType, buildContext.directiveBuilderParams())).map(directive -> this.toGraphQLDirective((Directive)directive, buildContext)).collect(Collectors.toList());
    }

    private GraphQLFieldDefinition toGraphQLField(Operation operation, BuildContext buildContext) {
        GraphQLOutputType type = this.toGraphQLType(operation.getJavaType(), buildContext);
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription()).deprecate(operation.getDeprecationReason()).type(type).withDirective(Directives.mappedOperation(operation)).withDirectives(this.toGraphQLDirectives(operation.getTypedElement(), buildContext.directiveBuilder::buildFieldDefinitionDirectives, buildContext));
        List<GraphQLArgument> arguments = operation.getArguments().stream().filter(OperationArgument::isMappable).map(argument -> this.toGraphQLArgument((OperationArgument)argument, buildContext)).collect(Collectors.toList());
        fieldBuilder.arguments(arguments);
        if (GraphQLUtils.isRelayConnectionType((GraphQLType)type) && buildContext.relayMappingConfig.strictConnectionSpec) {
            this.validateConnectionSpecCompliance(operation.getName(), arguments, buildContext.relay);
        }
        return buildContext.transformers.transform(fieldBuilder.build(), operation, this, buildContext);
    }

    public GraphQLFieldDefinition toGraphQLField(String parentType, Operation operation, BuildContext buildContext) {
        GraphQLFieldDefinition field = this.toGraphQLField(operation, buildContext);
        DataFetcher resolver = this.createResolver(operation, buildContext);
        buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)field.getName()), resolver);
        return field;
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, BuildContext buildContext) {
        return this.toGraphQLType(javaType, new HashSet<Class<? extends TypeMapper>>(), buildContext);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        GraphQLOutputType type = buildContext.typeMappers.getTypeMapper(javaType, mappersToSkip).toGraphQLType(javaType, this, mappersToSkip, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        buildContext.typeCache.completeType(type);
        return type;
    }

    public GraphQLInputObjectField toGraphQLInputField(InputField inputField, BuildContext buildContext) {
        GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(inputField.getName()).description(inputField.getDescription()).type(this.toGraphQLInputType(inputField.getJavaType(), buildContext)).withDirective(Directives.mappedInputField(inputField)).withDirectives(this.toGraphQLDirectives(inputField.getTypedElement(), buildContext.directiveBuilder::buildInputFieldDefinitionDirectives, buildContext)).defaultValue(inputField.getDefaultValue());
        return buildContext.transformers.transform(builder.build(), inputField, this, buildContext);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, BuildContext buildContext) {
        return this.toGraphQLInputType(javaType, new HashSet<Class<? extends TypeMapper>>(), buildContext);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        GraphQLInputType type = buildContext.typeMappers.getTypeMapper(javaType, mappersToSkip).toGraphQLInputType(javaType, this, mappersToSkip, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        return type;
    }

    private GraphQLArgument toGraphQLArgument(OperationArgument operationArgument, BuildContext buildContext) {
        GraphQLArgument argument = GraphQLArgument.newArgument().name(operationArgument.getName()).description(operationArgument.getDescription()).type(this.toGraphQLInputType(operationArgument.getJavaType(), buildContext)).defaultValue(operationArgument.getDefaultValue()).withDirectives(this.toGraphQLDirectives(operationArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext)).build();
        return buildContext.transformers.transform(argument, operationArgument, this, buildContext);
    }

    private GraphQLDirective[] toGraphQLDirectives(TypedElement element, BiFunction<AnnotatedElement, DirectiveBuilderParams, List<Directive>> directiveBuilder, BuildContext buildContext) {
        return (GraphQLDirective[])element.getElements().stream().flatMap(el -> ((List)directiveBuilder.apply((AnnotatedElement)el, buildContext.directiveBuilderParams())).stream()).map(directive -> this.toGraphQLDirective((Directive)directive, buildContext)).toArray(GraphQLDirective[]::new);
    }

    public GraphQLDirective toGraphQLDirective(Directive directive, BuildContext buildContext) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(directive.getDescription()).validLocations(directive.getLocations());
        directive.getArguments().forEach(arg -> builder.argument(this.toGraphQLArgument((DirectiveArgument)arg, buildContext)));
        return buildContext.transformers.transform(builder.build(), directive, this, buildContext);
    }

    private GraphQLArgument toGraphQLArgument(DirectiveArgument directiveArgument, BuildContext buildContext) {
        GraphQLArgument argument = GraphQLArgument.newArgument().name(directiveArgument.getName()).description(directiveArgument.getDescription()).type(this.toGraphQLInputType(directiveArgument.getJavaType(), buildContext)).value(directiveArgument.getValue()).defaultValue(directiveArgument.getDefaultValue()).withDirectives(this.toGraphQLDirectives(directiveArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext)).build();
        return buildContext.transformers.transform(argument, directiveArgument, this, buildContext);
    }

    private GraphQLFieldDefinition toRelayMutation(String parentType, GraphQLFieldDefinition mutation, DataFetcher<?> resolver, BuildContext buildContext) {
        List<GraphQLFieldDefinition> outputFields;
        String payloadTypeName = mutation.getName() + "Payload";
        if (mutation.getType() instanceof GraphQLObjectType) {
            outputFields = ((GraphQLObjectType)mutation.getType()).getFieldDefinitions();
        } else {
            outputFields = new ArrayList();
            outputFields.add(GraphQLFieldDefinition.newFieldDefinition().name(buildContext.relayMappingConfig.wrapperFieldName).description(buildContext.relayMappingConfig.wrapperFieldDescription).type(mutation.getType()).build());
            DataFetcher wrapperFieldResolver = DataFetchingEnvironment::getSource;
            buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)payloadTypeName, (String)buildContext.relayMappingConfig.wrapperFieldName), wrapperFieldResolver);
        }
        List inputFields = mutation.getArguments().stream().map(arg -> GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build()).collect(Collectors.toList());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(mutation.getName() + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(payloadTypeName).field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).fields(outputFields).build();
        PropertyDataFetcher simpleResolver = new PropertyDataFetcher("clientMutationId");
        DataFetcher clientMutationIdResolver = arg_0 -> OperationMapper.lambda$toRelayMutation$12((DataFetcher)simpleResolver, arg_0);
        buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)payloadTypeName, (String)"clientMutationId"), clientMutationIdResolver);
        GraphQLFieldDefinition relayMutation = GraphQLFieldDefinition.newFieldDefinition().name(mutation.getName()).type((GraphQLOutputType)outputType).argument(GraphQLArgument.newArgument().name("input").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)inputObjectType))).build();
        DataFetcher wrappedResolver = env -> {
            RelayDataFetchingEnvironmentDecorator innerEnv = new RelayDataFetchingEnvironmentDecorator(env);
            if (env.getContext() instanceof ContextWrapper) {
                ContextWrapper context = (ContextWrapper)env.getContext();
                context.setClientMutationId((String)innerEnv.getArgument("clientMutationId"));
            } else if (env.getContext() instanceof GraphQLContext) {
                GraphQLContext context = (GraphQLContext)env.getContext();
                context.put((Object)"clientMutationId", innerEnv.getArgument("clientMutationId"));
            }
            return resolver.get((DataFetchingEnvironment)innerEnv);
        };
        buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)relayMutation.getName()), wrappedResolver);
        return relayMutation;
    }

    private DataFetcher createResolver(Operation operation, BuildContext buildContext) {
        Stream<AnnotatedType> inputTypes = operation.getArguments().stream().filter(OperationArgument::isMappable).map(OperationArgument::getJavaType);
        ValueMapper valueMapper = buildContext.createValueMapper(inputTypes);
        if (operation.isBatched()) {
            return environment -> new OperationExecutor(operation, valueMapper, buildContext.globalEnvironment, buildContext.interceptorFactory).execute(environment);
        }
        return new OperationExecutor(operation, valueMapper, buildContext.globalEnvironment, buildContext.interceptorFactory)::execute;
    }

    private DataFetcher createNodeResolver(Map<String, String> nodeQueriesByType, Relay relay) {
        return env -> {
            String typeName;
            try {
                typeName = relay.fromGlobalId((String)env.getArgument("id")).getType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(env.getArgument("id") + " is not a valid Relay node ID");
            }
            if (!nodeQueriesByType.containsKey(typeName)) {
                throw new IllegalArgumentException(typeName + " is not a Relay node type or no registered query can fetch it by ID");
            }
            GraphQLObjectType queryRoot = env.getGraphQLSchema().getQueryType();
            GraphQLFieldDefinition nodeQueryForType = queryRoot.getFieldDefinition((String)nodeQueriesByType.get(typeName));
            return env.getGraphQLSchema().getCodeRegistry().getDataFetcher((GraphQLFieldsContainer)queryRoot, nodeQueryForType).get(env);
        };
    }

    private Map<String, String> getNodeQueriesByType(List<Operation> queries, List<GraphQLFieldDefinition> graphQlQueries, TypeRegistry typeRegistry, GraphQLInterfaceType node, BuildContext buildContext) {
        HashMap<String, String> nodeQueriesByType = new HashMap<String, String>();
        for (int i = 0; i < queries.size(); ++i) {
            Operation query = queries.get(i);
            GraphQLFieldDefinition graphQlQuery = graphQlQueries.get(i);
            if (graphQlQuery.getArgument("id") == null || !GraphQLUtils.isRelayId(graphQlQuery.getArgument("id")) || query.getResolver("id") == null) continue;
            GraphQLType unwrappedQueryType = GraphQLUtils.unwrapNonNull((GraphQLType)graphQlQuery.getType());
            if ((unwrappedQueryType = buildContext.typeCache.resolveType(unwrappedQueryType.getName())) instanceof GraphQLObjectType && ((GraphQLObjectType)unwrappedQueryType).getInterfaces().contains(node)) {
                nodeQueriesByType.put(unwrappedQueryType.getName(), query.getName());
                continue;
            }
            if (unwrappedQueryType instanceof GraphQLInterfaceType) {
                typeRegistry.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
                continue;
            }
            if (!(unwrappedQueryType instanceof GraphQLUnionType)) continue;
            typeRegistry.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).filter(Directives::isMappedType).filter(implementation -> GenericTypeReflector.isSuperType((Type)query.getResolver("id").getReturnType().getType(), (Type)Directives.getMappedType((GraphQLType)implementation).getType())).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
        }
        return nodeQueriesByType;
    }

    private void log(Validator.ValidationResult result) {
        if (!result.isValid()) {
            log.warn(result.getMessage());
        }
    }

    private void validateConnectionSpecCompliance(String operationName, List<GraphQLArgument> arguments, Relay relay) {
        String errorMessageTemplate = "Operation '" + operationName + "' is incompatible with the Relay Connection spec due to %s. If this is intentional, disable strict compliance checking. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#relay-connection-spec-violation";
        boolean forwardPageSupported = relay.getForwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        boolean backwardPageSupported = relay.getBackwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        if (!forwardPageSupported && !backwardPageSupported) {
            throw new MappingException(String.format(errorMessageTemplate, "required arguments missing"));
        }
        if (relay.getConnectionFieldArguments().stream().anyMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName()) && !GraphQLUtils.unwrap((GraphQLType)arg.getType()).getName().equals(specArg.getType().getName())))) {
            throw new MappingException(String.format(errorMessageTemplate, "argument type mismatch"));
        }
    }

    public List<GraphQLFieldDefinition> getQueries() {
        return this.queries;
    }

    public List<GraphQLFieldDefinition> getMutations() {
        return this.mutations;
    }

    public List<GraphQLFieldDefinition> getSubscriptions() {
        return this.subscriptions;
    }

    public List<GraphQLDirective> getDirectives() {
        return this.directives;
    }

    private static /* synthetic */ String lambda$toRelayMutation$12(DataFetcher simpleResolver, DataFetchingEnvironment env) throws Exception {
        if (env.getContext() instanceof ContextWrapper) {
            return ((ContextWrapper)env.getContext()).getClientMutationId();
        }
        if (env.getContext() instanceof GraphQLContext) {
            return (String)((GraphQLContext)env.getContext()).get((Object)"clientMutationId");
        }
        return (String)simpleResolver.get(env);
    }
}

