/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.metadata.Directive;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilderParams;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Directives;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ObjectTypeMapper
extends CachingMapper<GraphQLObjectType, GraphQLInputObjectType> {
    @Override
    public GraphQLObjectType toGraphQLType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLObjectType.Builder typeBuilder = GraphQLObjectType.newObject().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType, buildContext.messageBundle));
        List<GraphQLFieldDefinition> fields = this.getFields(typeName, javaType, buildContext, operationMapper);
        fields.forEach(arg_0 -> ((GraphQLObjectType.Builder)typeBuilder).field(arg_0));
        List<GraphQLOutputType> interfaces = this.getInterfaces(javaType, fields, buildContext, operationMapper);
        interfaces.forEach(inter -> {
            if (inter instanceof GraphQLInterfaceType) {
                typeBuilder.withInterface((GraphQLInterfaceType)inter);
            } else {
                typeBuilder.withInterface((GraphQLTypeReference)inter);
            }
        });
        typeBuilder.withDirective(Directives.mappedType(javaType));
        buildContext.directiveBuilder.buildObjectTypeDirectives(javaType, buildContext.directiveBuilderParams()).forEach(directive -> typeBuilder.withDirective(operationMapper.toGraphQLDirective((Directive)directive, buildContext)));
        GraphQLObjectType type = typeBuilder.build();
        interfaces.forEach(inter -> buildContext.typeRegistry.registerCovariantType(inter.getName(), javaType, (GraphQLOutputType)type));
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInputObjectType.Builder typeBuilder = GraphQLInputObjectType.newInputObject().name(typeName).description(buildContext.typeInfoGenerator.generateInputTypeDescription(javaType, buildContext.messageBundle));
        InputFieldBuilderParams params = InputFieldBuilderParams.builder().withType(javaType).withEnvironment(buildContext.globalEnvironment).build();
        buildContext.inputFieldBuilders.getInputFields(params).forEach(field -> typeBuilder.field(operationMapper.toGraphQLInputField((InputField)field, buildContext)));
        if (ClassUtils.isAbstract(javaType)) {
            this.createInputDisambiguatorField(javaType, buildContext).ifPresent(arg_0 -> ((GraphQLInputObjectType.Builder)typeBuilder).field(arg_0));
        }
        typeBuilder.withDirective(Directives.mappedType(javaType));
        buildContext.directiveBuilder.buildInputObjectTypeDirectives(javaType, buildContext.directiveBuilderParams()).forEach(directive -> typeBuilder.withDirective(operationMapper.toGraphQLDirective((Directive)directive, buildContext)));
        return typeBuilder.build();
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }

    protected List<GraphQLFieldDefinition> getFields(String typeName, AnnotatedType javaType, BuildContext buildContext, OperationMapper operationMapper) {
        return buildContext.operationRegistry.getChildQueries(javaType).stream().map(childQuery -> operationMapper.toGraphQLField(typeName, (Operation)childQuery, buildContext)).collect(Collectors.toList());
    }

    protected List<GraphQLOutputType> getInterfaces(AnnotatedType javaType, List<GraphQLFieldDefinition> fields, BuildContext buildContext, OperationMapper operationMapper) {
        ArrayList<GraphQLOutputType> interfaces = new ArrayList<GraphQLOutputType>();
        if (buildContext.relayMappingConfig.inferNodeInterface && fields.stream().anyMatch(GraphQLUtils::isRelayId)) {
            interfaces.add((GraphQLOutputType)buildContext.node);
        }
        buildContext.interfaceStrategy.getInterfaces(javaType).forEach(inter -> interfaces.add(operationMapper.toGraphQLType((AnnotatedType)inter, buildContext)));
        return interfaces;
    }

    protected Optional<GraphQLInputObjectField> createInputDisambiguatorField(AnnotatedType javaType, BuildContext buildContext) {
        Class raw = ClassUtils.getRawType(javaType.getType());
        String typeName = buildContext.typeInfoGenerator.generateTypeName(GenericTypeReflector.annotate(raw), buildContext.messageBundle) + "TypeDisambiguator";
        GraphQLTypeReference fieldType = null;
        if (buildContext.typeCache.contains(typeName)) {
            fieldType = new GraphQLTypeReference(typeName);
        } else {
            List impls = buildContext.abstractInputHandler.findConcreteSubTypes(raw, buildContext).stream().map(GenericTypeReflector::annotate).collect(Collectors.toList());
            if (impls.size() > 1) {
                buildContext.typeCache.register(typeName);
                GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(typeName).description("Input type discriminator");
                impls.stream().map(t -> buildContext.typeInfoGenerator.generateTypeName((AnnotatedType)t, buildContext.messageBundle)).forEach(arg_0 -> ((GraphQLEnumType.Builder)builder).value(arg_0));
                fieldType = builder.build();
            }
        }
        return Optional.ofNullable(fieldType).map(type -> GraphQLInputObjectField.newInputObjectField().name("_type_").type(type).build());
    }
}

