/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLId;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.ArgumentBuilderParams;
import io.leangen.graphql.metadata.strategy.query.ResolverArgumentBuilder;
import io.leangen.graphql.metadata.strategy.value.DefaultValueProvider;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.ReservedStrings;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedArgumentBuilder
implements ResolverArgumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedArgumentBuilder.class);

    @Override
    public List<OperationArgument> buildResolverArguments(ArgumentBuilderParams params) {
        Method resolverMethod = params.getResolverMethod();
        ArrayList<OperationArgument> operationArguments = new ArrayList<OperationArgument>(resolverMethod.getParameterCount());
        AnnotatedType[] parameterTypes = ClassUtils.getParameterTypes(resolverMethod, params.getDeclaringType());
        for (int i = 0; i < resolverMethod.getParameterCount(); ++i) {
            AnnotatedType parameterType;
            Parameter parameter = resolverMethod.getParameters()[i];
            if (parameter.isSynthetic() || parameter.isImplicit()) continue;
            try {
                parameterType = params.getTypeTransformer().transform(parameterTypes[i]);
            }
            catch (TypeMappingException e) {
                throw new TypeMappingException(resolverMethod, parameter, (Exception)e);
            }
            operationArguments.add(this.buildResolverArgument(parameter, parameterType, params.getInclusionStrategy(), params.getEnvironment()));
        }
        return operationArguments;
    }

    protected OperationArgument buildResolverArgument(Parameter parameter, AnnotatedType parameterType, InclusionStrategy inclusionStrategy, GlobalEnvironment environment) {
        return new OperationArgument(parameterType, this.getArgumentName(parameter, parameterType, inclusionStrategy, environment.messageBundle), this.getArgumentDescription(parameter, parameterType, environment.messageBundle), this.defaultValue(parameter, parameterType, environment), parameter, parameter.isAnnotationPresent(GraphQLContext.class), inclusionStrategy.includeArgument(parameter, parameterType));
    }

    protected String getArgumentName(Parameter parameter, AnnotatedType parameterType, InclusionStrategy inclusionStrategy, MessageBundle messageBundle) {
        if (Optional.ofNullable(parameterType.getAnnotation(GraphQLId.class)).filter(GraphQLId::relayId).isPresent()) {
            return "id";
        }
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        if (meta != null && !meta.name().isEmpty()) {
            return messageBundle.interpolate(meta.name());
        }
        if (!parameter.isNamePresent() && inclusionStrategy.includeArgument(parameter, parameterType)) {
            log.warn("No explicit argument name given and the parameter name lost in compilation: " + parameter.getDeclaringExecutable().toGenericString() + "#" + parameter.toString() + ". For details and possible solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#missing-argument-name");
        }
        return parameter.getName();
    }

    protected String getArgumentDescription(Parameter parameter, AnnotatedType parameterType, MessageBundle messageBundle) {
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        return meta != null ? messageBundle.interpolate(meta.description()) : null;
    }

    protected Object defaultValue(Parameter parameter, AnnotatedType parameterType, GlobalEnvironment environment) {
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        if (meta == null) {
            return null;
        }
        try {
            return this.defaultValueProvider(meta.defaultValueProvider(), environment).getDefaultValue(parameter, environment.getMappableInputType(parameterType), ReservedStrings.decode(environment.messageBundle.interpolate(meta.defaultValue())));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(meta.defaultValueProvider().getName() + " must expose a public default constructor, or a constructor accepting " + GlobalEnvironment.class.getName(), e);
        }
    }

    protected <T extends DefaultValueProvider> T defaultValueProvider(Class<T> type, GlobalEnvironment environment) throws ReflectiveOperationException {
        try {
            return (T)((DefaultValueProvider)type.getConstructor(GlobalEnvironment.class).newInstance(environment));
        }
        catch (NoSuchMethodException e) {
            return (T)((DefaultValueProvider)type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }
}

