/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLSubscription;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.query.AnnotatedArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationInfoGenerator;
import io.leangen.graphql.metadata.strategy.query.PublicResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.metadata.strategy.value.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class AnnotatedResolverBuilder
extends PublicResolverBuilder {
    public AnnotatedResolverBuilder() {
        this.operationInfoGenerator = new DefaultOperationInfoGenerator();
        this.argumentBuilder = new AnnotatedArgumentBuilder();
        this.propertyElementReducer = AnnotatedResolverBuilder::annotatedElementReducer;
        this.withDefaultFilters();
    }

    @Override
    protected boolean isQuery(Method method, ResolverBuilderParams params) {
        return method.isAnnotationPresent(GraphQLQuery.class);
    }

    @Override
    protected boolean isQuery(Field field, ResolverBuilderParams params) {
        return field.isAnnotationPresent(GraphQLQuery.class);
    }

    @Override
    protected boolean isQuery(Property property, ResolverBuilderParams params) {
        return this.isQuery(property.getGetter(), params) || this.isQuery(property.getField(), params);
    }

    @Override
    protected boolean isMutation(Method method, ResolverBuilderParams params) {
        return method.isAnnotationPresent(GraphQLMutation.class);
    }

    @Override
    protected boolean isSubscription(Method method, ResolverBuilderParams params) {
        return method.isAnnotationPresent(GraphQLSubscription.class);
    }

    private static TypedElement annotatedElementReducer(TypedElement field, TypedElement getter) {
        if (field.isAnnotationPresent(GraphQLQuery.class) && getter.isAnnotationPresent(GraphQLQuery.class)) {
            throw new TypeMappingException("Ambiguous mapping of " + field);
        }
        return field.isAnnotationPresent(GraphQLQuery.class) ? field : getter;
    }
}

